<?php
namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ClientsModel;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Clients extends BaseController {

    public function __construct() {
        $db 						= db_connect();
        $this->userModel     		= new ClientsModel($db);

        $this->ip_address 			= $_SERVER['REMOTE_ADDR'];
        $this->datetime 			= date("Y-m-d H:i:s");
    }

    public function index() {
        echo view("clients/index");
    }

    public function display() {
        $data 	= [];
        $data ["result"] = $this->userModel->getUserList();
        echo view("clients/display", $data);
    }

    public function import() {
        $path 			= 'documents/users/';
        $json 			= [];
        $file_name 		= $this->request->getFile('file');
        $file_name 		= $this->uploadFile($path, $file_name);
        $arr_file 		= explode('.', $file_name);
        $extension 		= end($arr_file);
        if('csv' == $extension) {
            $reader 	= new \PhpOffice\PhpSpreadsheet\Reader\Csv();
        } else {
            $reader 	= new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        }
        $spreadsheet 	= $reader->load($file_name);
        $sheet_data 	= $spreadsheet->getActiveSheet()->toArray();

        $list 			= [];
        foreach($sheet_data as $key => $val) {
            if ($key != 0) {
                $list [] = [
                    'Code_Site_Web' => $val[0],
                    'Login' => $val[1],
                    'Ident_Client' => $val[2],
                    'Password' => $val[3],
                    'Civ_Fact' => $val[4],
                    'Nom_Fact' => $val[5],
                    'Prenom_Fact' => $val[6],
                    'Societe_Fact' => $val[7],
                    'Adresse_1_Fact' => $val[8],
                    'Adresse_2_Fact' => $val[9],
                    'Adresse_3_Fact' => $val[10],
                    'Code_Postal_Fact' => $val[11],
                    'Ville_Fact' => $val[12],
                    'Code_Pays_Fact' => $val[13],
                    'Tel_Fact' => $val[14],
                    'Fax_Fact' => $val[15],
                    'Email_Fact' => $val[16],
                    'Civ_Liv' => $val[17],
                    'Nom_Liv' => $val[18],
                    'Prenom_Liv' => $val[19],
                    'Societe_Liv' => $val[20],
                    'Adresse_1_Liv' => $val[21],
                    'Adresse_2_Liv' => $val[22],
                    'Adresse_3_Liv' => $val[23],
                    'Code_Postal_Liv' => $val[24],
                    'Ville_Liv' => $val[25],
                    'Code_Pays_Liv' => $val[26],
                    'Tel_Liv' => $val[27],
                    'Fax_Liv' => $val[28],
                    'Email_Liv' => $val[29],
                    'Num_Client' => $val[30],
                    'Mode_Reglement' => $val[31],
                    'Mode_Expedition' => $val[32],
                    'Actif' => $val[33],
                    'Code_Tarif' => $val[34],
                    'Famille_Client' => $val[35],

                ];


            }
        }

        if(file_exists($file_name))
            //unlink($file_name);
            if(count($list) > 0) {
                $result 	= $this->userModel->bulkInsert($list);
                if($result) {
                    $json = [
                        'success' 	=> "All Entries are imported successfully.",
                    ];
                } else {
                    $json = [
                        'error' 	=> "Something went wrong. Please try again."
                    ];
                }
            } else {
                $json = [
                    'error' => "No new record is found.",
                ];
            }

        return json_encode($json);
    }

    public function uploadFile($path, $image) {
        if (!is_dir($path))
            mkdir($path, 0777, TRUE);
        if ($image->isValid() && ! $image->hasMoved()) {
            $newName = $image->getRandomName();
            $image->move('./'.$path, $newName);
            return $path.$image->getName();
        }
        return "";
    }

}