<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\SysAuthModel;
use App\Entities\SysUserEntity;
use App\Models\SysWebInfoModel;
use App\Entities\SysWebInfoEntity;
use Config\Services;

class SysAuth extends BaseController
{
	private $page_controller = "sysauth";

	public function index()
	{
        if(!session()->get('logged_in')){
            return redirect()->to(auth_url("login")); 
        } else {
            return redirect()->to(admin_url(""));
		}
	}

	public function logout()
    {
        $session = session();
        $session->destroy();
        return redirect()->to(auth_url(""));
    }

	public function pleaseLogin()
	{
		$output = [
			"page_controller" => $this->page_controller,
			"page_title" => "Login"
		];
		echo view("sysauth/pleaseLogin", $output);
	}

	public function login()
	{
		$syswebinfoModel = new SysWebInfoModel();
		$data = $syswebinfoModel->getSelect("syswebinfo.row_id = '1'");		

		$ses_data = [
			'company_name' => $data->company_name,
			'application_name' => $data->application_name,
			'format_date' => $data->format_date,
			'currency' => $data->currency,
			'web_icon' => $data->web_icon,
			'company_logo' => $data->company_logo,
		];
		$session = session();
		$session->set($ses_data);

		$output = [
			"page_controller" => $this->page_controller,
			"page_title" => "Login"
		];
		echo view("sysauth/login", $output);
	}

	public function saveLogin()
	{
		$status = 0;
		$msg = "";
        $request = Services::request();
		$user_id = $request->getPost("user_id");
		$pswrd = $request->getPost("pswrd");
		$model = new SysAuthModel();
		$data = $model->getAuthLogin(["user_id" => $user_id]);
		if($data) {
			$pswrd_db = $data["pswrd"];
			$verify_pswrd = password_verify($pswrd, $pswrd_db);
			if($verify_pswrd){
                $ses_data = [
                    'user_id' => $data['user_id'],
                    'name' => $data['name'],
                    'title' => $data['title'],
                    'email' => $data['email'],
                    'user_access_id' => $data['user_access_id'],
                    'user_access_id_txt' => $data['user_access_id_txt'],
                    'logged_in' => TRUE
                ];
				$session = session();
                $session->set($ses_data);
                $status = 1;
            }else{
                $status = 0;
				$msg = "Wrong password";
            }
		} else {
			$status = 0;
			$msg = "Invalid User Id";
		}

		$output = array(
			"sistemator_token" => csrf_hash(),
			"msg" => $msg,
			"status" => $status,
		);

		echo json_encode($output);
	}

}
