<?php

namespace App\Controllers;

use App\Models\GeneralModel;
use App\Models\SysUserModel;
use App\Entities\SysUserEntity;
use App\Controllers\BaseController;
use Config\Services;
use CodeIgniter\Exceptions\PageNotFoundException;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class SysHome extends BaseController
{
	private $page_controller = "syshome";
	private $page_route = "home";

	public function index()
	{		
		$page_button = button([
			["access" => "Read only", "url" => admin_url("edit-profile"), "label" => str("edit_profile"), "color" => "success"],
			["access" => "Read only", "url" => admin_url("change-password"), "label" => str("change_password")]
		]);

		$output = [
			"page_controller" => $this->page_controller,
			"page_title" => str("welcome"),
			"page_route" => $this->page_route,
			"page_button" => $page_button,
		];
		echo view("syshome/index", $output);
	}

	public function editProfile() 
	{
		$page_button = button([
			["access" => "Read only", "label" => str("button_save"), "id" => "btn_save", "onclick" => "save('form_input', 'btn_save')", "color" => "success"]
		]);

		$sysuserModel = new SysUserModel();
		$data = $sysuserModel->getSelect("sysuser.user_id = '".session()->get('user_id')."'");
		
		$output = [
			"page_controller" => $this->page_controller,
			"page_title" => str("edit_profile"),
			"page_route" => $this->page_route,
			"page_button" => $page_button,
			"row_id" => enkripsi($data->row_id),
			"data" => $data,
		];
		echo view("syshome/edit_profile", $output);
	}	

	public function saveEditProfile() {
        $request = Services::request();
		$sysuserModel = new SysUserModel();
		$input = new SysUserEntity();
		$valid = true;
		$msg = str("process_successful");
		$status = 1;

		$row_id = $request->getPost("row_id");
		$input->row_id = dekripsi($row_id);		
		$input->modified_date = getDatetime();
		$input->modified_by = sesUsername();
        $input->name = $request->getPost("name");
        $input->title = $request->getPost("title");
        $input->email = $request->getPost("email");
		$sysuserModel->save($input);

		$ses_data = [
			'name' => $request->getPost("name"),
			'title' => $request->getPost("title"),
			'email' => $request->getPost("email")
		];
		$session = session();
		$session->set($ses_data);

		$output = array(
			"sistemator_token" => csrf_hash(),
			"msg" => $msg,
			"status" => $status,
		);

		echo json_encode($output);
	}

	public function changePassword() 
	{
		$page_button = button([
			["access" => "Read only", "label" => str("button_save"), "id" => "btn_save", "onclick" => "save('form_input', 'btn_save')", "color" => "success"]
		]);

		$sysuserModel = new SysUserModel();
		$data = $sysuserModel->getSelect("sysuser.user_id = '".session()->get('user_id')."'");
		
		$output = [
			"page_controller" => $this->page_controller,
			"page_title" => str("change_password"),
			"page_route" => $this->page_route,
			"page_button" => $page_button,
			"row_id" => enkripsi($data->row_id),
			"data" => $data,
		];
		echo view("syshome/change_password", $output);
	}	

	public function saveChangePassword() {
        $request = Services::request();
		$sysuserModel = new SysUserModel();
		$input = new SysUserEntity();
		$valid = true;
		$msg = str("process_successful");
		$status = 1;

		$row_id = $request->getPost("row_id");
		$input->row_id = dekripsi($row_id);		
		$input->modified_date = getDatetime();
		$input->modified_by = sesUsername();
        if($request->getPost("new_password") != "") {
			$input->pswrd = password_hash($request->getPost("new_password"), PASSWORD_DEFAULT);
		}
		$sysuserModel->save($input);

		$output = array(
			"sistemator_token" => csrf_hash(),
			"msg" => $msg,
			"status" => $status,
		);

		echo json_encode($output);
	}
}
