<?php

namespace App\Controllers;

use App\Models\GeneralModel;
use App\Models\SysIconModel;
use App\Entities\SysIconEntity;
use App\Controllers\BaseController;
use Config\Services;
use CodeIgniter\Exceptions\PageNotFoundException;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class SysIcon extends BaseController
{
	private $page_controller = "sysicon";
	private $page_route = "icon";

	public function index()
	{		
		$page_button = button([
			["access" => getAccess($this->page_route), "label" => str("button_create_new"), "url" => admin_url($this->page_route."/form/0")]
		]);

		$output = [
			"page_controller" => $this->page_controller,
			"page_route" => $this->page_route,
			"page_button" => $page_button,
			"page_title" => str("sysicon")
		];
		echo view("sysicon/index", $output);
	}

	public function datatable()
    {
        $request = Services::request();
		$sysicon_model = new SysIconModel($request);
		$where = $request->getPost('where');
		$list = $sysicon_model->getDatatables($where);
		$no = $request->getPost('start');
		$data = [];

		foreach ($list as $lines) {
			$row_id = enkripsi($lines["row_id"]);
			$line = new SysIconEntity();
			$line->fill($lines);
			
			$button = buttonTable([
				["access" => getAccess($this->page_route), "label" => str("button_edit"), "url" => admin_url($this->page_route."/form/".$row_id)]
			]);

			$link_view = linkView(["form_id" => dekripsi($row_id), "value" => $line->icon_code, "title" => str("sysicon"), "url" => admin_url($this->page_route."/preview/".$row_id)]);

			$row = [];
			$row[] = $button;
            $row[] = printIcon(["value" => $line->icon_code]);
            $row[] = $link_view;
			$data[] = $row;
		}

		$output = [
			"draw" => $request->getPost("draw"),
			"recordsTotal" => $sysicon_model->countAll(),
			"recordsFiltered" => $sysicon_model->countFiltered($where),
			"data" => $data,
			"sistemator_token" => csrf_hash()
		];

		echo json_encode($output);
    }

	public function form($id=null) 
	{
		$row_id = dekripsi($id);

		$page_button = button([
			["access" => getAccess($this->page_route), "label" => str("button_save"), "id" => "btn_save", "onclick" => "save('form_input', 'btn_save')", "color" => "success"],
			["access" => getAccess($this->page_route), "label" => str("button_delete"), "onclick" => "deleteSysIcon()", "color" => "danger"]
		]);

		$sysicon_model = new SysIconModel();
		$data = $sysicon_model->getSelect("sysicon.row_id = '".$row_id."'");
		
		$output = [
			"page_controller" => $this->page_controller,
			"page_title" => str("sysicon"),
			"page_route" => $this->page_route,
			"page_button" => $page_button,
			"row_id" => $id,
			"data" => $data,
		];
		echo view("sysicon/form", $output);
	}

	public function save() {
        $request = Services::request();
		$sysicon_model = new SysIconModel();
		$input = new SysIconEntity();
		$valid = true;
		$msg = str("process_successful");
		$status = 1;

		$row_id = $request->getPost("row_id");
		$state = ($row_id == "0") ? "create" : "update";
		if($state  == "create") {
			$input->created_date = getDatetime();
			$input->created_by = sesUsername();

			$validation = [
				["type" => "unique", "field" => "icon_code", "value" => $request->getPost("icon_code")],];
			if($validation != null) {
				$return_validation = $sysicon_model->checkValidation($validation);
				if(!$return_validation["valid"]) {
					$valid = false;
					$msg = $return_validation["msg"];
					$status = 0;
				}
			}
		}

		$input->row_id = dekripsi($row_id);		
		$input->modified_date = getDatetime();
		$input->modified_by = sesUsername();
        $input->icon_code = $request->getPost("icon_code");

		if($valid) {
			$sysicon_model->save($input);
			$row_id = $sysicon_model->getInsertID();
		}

		$output = array(
			"sistemator_token" => csrf_hash(),
			"msg" => $msg,
			"status" => $status,
		);

		echo json_encode($output);
	}

	public function delete() 
	{
        $request = Services::request();
		$sysicon_model = new SysIconModel();
		$sysicon_model->deleteData(dekripsi($request->getGet('id')));

		$output = array(
			"sistemator_token" => csrf_hash(),
			"msg" => "Process successful",
			"status" => 1,
		);

		echo json_encode($output);
	}

	public function excel() 
	{
		$sysicon_model = new SysIconModel();
		$data = $sysicon_model->exportExcel();		
		generateExcel($data, str("sysicon"));
	}
}
