<?php

namespace App\Entities;

use CodeIgniter\Entity;

class SalesEntity extends Entity
{
	protected $datamap = [
        "trans_date" => "trans_date", 
        "customer_id" => "customer_id", 
        "product_id" => "product_id", 
        "description" => "description", 
        "qty" => "qty", 
        "total_amount" => "total_amount", 
        "taxed" => "taxed", 
        "doc_list" => "doc_list", 
        "status" => "status", 
        "created_date" => "created_date",
        "created_by" => "created_by",
        "modified_date" => "modified_date",
        "modified_by" => "modified_by",
        "deleted_date" => "deleted_date",
        "deleted_by" => "deleted_by",
	];

	protected $dates = [];
    
	protected $casts = [];	

    public function setTotalamount($value)
    {
        $this->attributes["total_amount"] = convert_money($value);
        return $this;
    }	

    public function setTaxed($value)
    {
        if($value == "on" || $value == "YES") {
            $ret = "YES";
        } else {
            $ret = "NO";
        }
        $this->attributes["taxed"] = $ret;
        return $this;
    }	

    public function getTaxed()
    {
        $ret = null;
        if(array_key_exists("taxed", $this->attributes)) {
            $attribute = $this->attributes["taxed"];
            if($attribute == "on" || $attribute == "YES") {
                $ret = "YES";
            }
        }
        return $ret;
    }
                
    public function setDoclist($value)
	{
        if(is_array($value)) {
            $this->attributes["doc_list"] = ($value != "") ? implode("|", $value): "";
        } else {
            $this->attributes["doc_list"] = $value;
        }
        return $this;
    }
}
