<?php

function admin_url($url) {
    return site_url("admin/".$url);
}

function auth_url($url) {
    return site_url("auth/".$url);
}

function unique_code() {
    return "S!ST3M4T0R";
}

function par_id() {
    return "!@)(*&^%&%$%_###_";
}

function asset_uploaded() {
    return base_url("uploaded");
}

function convert_money($money) {
    return str_replace(",", "", $money);
}

function str($text) {
    return lang("Text.".$text);
}

function getDatetime() {
    return date("Y-m-d H:i:s");
}

function enkripsi($id) {
    $enkripsi_id = par_id().$id.unique_code();
    return base64_encode($enkripsi_id);
}

function dekripsi($id) {
    $dekripsi_id = base64_decode($id);
    $dekripsi_id = str_replace(par_id(), "", $dekripsi_id);
    $dekripsi_id = str_replace(unique_code(), "", $dekripsi_id);
    return $dekripsi_id;
}

function setAccessToken($route, $access) {
    $key = session()->get('user_id')."{}".$route."{}".$access;
    return base64_encode($key);
}

function getAccessToken($route, $key) {
    $access = "";
    $dekripsi = base64_decode($key);
    if(strpos($dekripsi, "{}") !== false) {
        $token = explode("{}", $dekripsi);
        $user_id = $token[0];
        $rt = $token[1];
        if(strtolower($route) == strtolower($rt)) {
            if($user_id == session()->get('user_id')) {
                $access = $token[2];
            }
        }
    }

    if($access == "") {
        header('Location: '.auth_url("please-login"));
    } else {
        return $access;
    }
    
}

function sesUsername() {
    return "Admin";
}

function getAccess($route)
{
    $model = new \App\Models\SysUserAccessModel();  
    $access = $model->getUserAccess($route);
    if($access == "") {   
        header('Location: '.auth_url("no-authorization"));
    } else {
        return $access;
    }
}

?>