<?php

function inputText($data) {
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $label = "";
    $mandatory = "";
    $onblur = "";

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('readonly', $data)) {
        $readonly = $data['readonly'];
    }
    if (array_key_exists('placeholder', $data)) {
        $placeholder = $data['placeholder'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }
    if (array_key_exists('onchange', $data)) {
        $onchange = 'onchange="'.$data['onchange'].'"';
    }

    $attr = array(
        'autocomplete' => 'off',
        'type' => 'text',
        'class' => 'form-control form-control-cpx', 
        'value' => $value,
    );
    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($value != "") {
        $attr['value'] = $value;
    }
    if($readonly != "") {
        $attr['readonly'] = $readonly;
    }
    if($placeholder != "") {
        $attr['placeholder'] = $placeholder;
    }

    return $label.form_input($attr);
}

function inputPassword($data) {
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $label = "";
    $mandatory = "";
    $onblur = "";

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('readonly', $data)) {
        $readonly = $data['readonly'];
    }
    if (array_key_exists('placeholder', $data)) {
        $placeholder = $data['placeholder'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }
    if (array_key_exists('onchange', $data)) {
        $onchange = 'onchange="'.$data['onchange'].'"';
    }

    $attr = array(
        'autocomplete' => 'off',
        'type' => 'password',
        'class' => 'form-control form-control-cpx', 
        'value' => $value,
    );
    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($value != "") {
        $attr['value'] = $value;
    }
    if($readonly != "") {
        $attr['readonly'] = $readonly;
    }
    if($placeholder != "") {
        $attr['placeholder'] = $placeholder;
    }

    return $label.form_input($attr);
}

function inputEmail($data) {
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $label = "";
    $mandatory = "";
    $onblur = "";

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('readonly', $data)) {
        $readonly = $data['readonly'];
    }
    if (array_key_exists('placeholder', $data)) {
        $placeholder = $data['placeholder'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }
    if (array_key_exists('onchange', $data)) {
        $onchange = 'onchange="'.$data['onchange'].'"';
    }

    $attr = array(
        'autocomplete' => 'off',
        'type' => 'email',
        'class' => 'form-control form-control-cpx', 
        'value' => $value,
    );
    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($value != "") {
        $attr['value'] = $value;
    }
    if($readonly != "") {
        $attr['readonly'] = $readonly;
    }
    if($placeholder != "") {
        $attr['placeholder'] = $placeholder;
    }

    return $label.form_input($attr);
}

function inputTextWtInfo($data) {
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $label = "";
    $mandatory = "";
    $info = "";

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('info', $data)) {
        $info = $data['info'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('readonly', $data)) {
        $readonly = $data['readonly'];
    }
    if (array_key_exists('placeholder', $data)) {
        $placeholder = $data['placeholder'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }    

    $attr = [
        'autocomplete' => 'off',
        'type' => 'text',
        'class' => 'form-control form-control-cpx', 
        'value' => $value,
    ];

    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($value != "") {
        $attr['value'] = $value;
    }
    if($readonly != "") {
        $attr['readonly'] = $readonly;
    }
    if($placeholder != "") {
        $attr['placeholder'] = $placeholder;
    }

    return $label.'
    <div class="input-group">
        <div class="input-group-text">'.$info.'</div>
        '.form_input($attr).'
    </div>';
}

function InputTextarea($data) {
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $label = "";
    $mandatory = "";

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }

    $attr = array(
        'class' => 'form-control form-control-cpx', 
        'rows' => '3'
    );
    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($value != "") {
        $attr['value'] = $value;
    }

    return $label.form_textarea($attr);
}

function inputNumber($data) {
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $label = "";
    $mandatory = "";

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('readonly', $data)) {
        $readonly = $data['readonly'];
    }
    if (array_key_exists('placeholder', $data)) {
        $placeholder = $data['placeholder'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }

    $attr = array(
        'autocomplete' => 'off',
        'type' => 'number',
        'class' => 'form-control form-control-cpx', 
        'value' => $value,
    );
    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($value != "") {
        $attr['value'] = $value;
    }
    if($readonly != "") {
        $attr['readonly'] = $readonly;
    }
    if($placeholder != "") {
        $attr['placeholder'] = $placeholder;
    }

    return $label.form_input($attr);
}

function inputHidden($data) {
    $id = "";
    $value = "";
    foreach($data as $key => $value) {
        $id = $key;
    }
    $attr['id'] = $id;
    $attr['name'] = $id;
    $attr['type'] = 'hidden';
    $attr['value'] = $value;
    return form_input($attr);
}

function inputDate($data) {
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $label = "";
    $mandatory = "";

    if($value == "0000-00-00") {
        $value = "";
    }

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('readonly', $data)) {
        $readonly = $data['readonly'];
    }
    if (array_key_exists('placeholder', $data)) {
        $placeholder = $data['placeholder'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }

    $attr = array(
        'autocomplete' => 'off',
        'type' => 'date',
        'class' => 'form-control datepicker-basic',
        'value' => $value,
    );
    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($value != "") {
        $attr['value'] = $value;
    }
    if($readonly != "") {
        $attr['readonly'] = $readonly;
    }
    if($placeholder != "") {
        $attr['placeholder'] = $placeholder;
    }

    return $label.'
        <div class="input-group">
            '.form_input($attr).'
            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
        </div>
    ';
}

function inputDatetime($data) {
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $label = "";
    $mandatory = "";

    if($value == "0000-00-00") {
        $value = "";
    }

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('readonly', $data)) {
        $readonly = $data['readonly'];
    }
    if (array_key_exists('placeholder', $data)) {
        $placeholder = $data['placeholder'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }

    $attr = array(
        'autocomplete' => 'off',
        'type' => 'text',
        'class' => 'form-control datepicker-datetime',
        'value' => $value,
    );
    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($value != "") {
        $attr['value'] = $value;
    }
    if($readonly != "") {
        $attr['readonly'] = $readonly;
    }
    if($placeholder != "") {
        $attr['placeholder'] = $placeholder;
    }

    return $label.'
        <div class="input-group">
            '.form_input($attr).'
            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
        </div>
    ';
}

function inputMoney($data) 
{
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $group_text = "";
    $label = "";
    $mandatory = "";

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('readonly', $data)) {
        $readonly = $data['readonly'];
    }
    if (array_key_exists('placeholder', $data)) {
        $placeholder = $data['placeholder'];
    }
    if (array_key_exists('group_text', $data)) {
        $group_text = $data['group_text'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }

    $attr = array(
        'autocomplete' => 'off',
        'type' => 'text',
        'class' => 'form-control form-control-cpx input-money', 
        'value' => $value,
    );
    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($value != "") {
        $attr['value'] = $value;
    }
    if($readonly != "") {
        $attr['readonly'] = $readonly;
    }
    if($placeholder != "") {
        $attr['placeholder'] = $placeholder;
    }

    return $label.'
        <div class="input-group">
            <div class="input-group-text">'.CURR.'</div>
            '.form_input($attr).'
        </div>
    ';
}

function checkNoYes($data) 
{
    $id = "";
    $name = "";
    $value = "";
    $label = "";
    $mandatory = "";

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }   
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }

    if ($value == "YES") {
        $checked = "checked";
    } else {
        $checked = "";
    }

    $ret = $label.'
        <div style="clear:both; height:0px"></div>
        <input type="checkbox" id="'.$id.'" name="'.$id.'" switch="none" '.$checked.' /><label for="'.$id.'" data-on-label="Yes" data-off-label="No"></label>
    ';

    return $ret;
}

function dropdownList($data) 
{
    $id = "";
    $name = "";
    $value = "";
    $label = "";
    $mandatory = "";
    $onchange = "";
    $list = array();

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('list', $data)) {
        $list = $data['list'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }
    if (array_key_exists('onchange', $data)) {
        $onchange = 'onchange="'.$data['onchange'].'"';
    }

    return $label.form_dropdown($id, $list, $value, 'id="'.$id.'" class="form-control form-select '.$value.'" '.$onchange);
}

function checkboxList($data) {
    $id = "";
    $name = "";
    $label = "";
    $mandatory = "";
    $value = "";
    $list = $data['list'];
    $checkbox = "";
        
    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id']."[]";
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }

    foreach($list as $row) {
        $checkedlist = explode("|", $value);
        $checked = "";
        foreach($checkedlist as $chk) {
            if($chk == $row->field_id) $checked = "checked";
        }

        $attr = array(
            'class' => 'form-check-input', 
            'value' => $row->field_id,
        );
        if($id != "") {
            $attr['id'] = $id;
        }
        if($name != "") {
            $attr['name'] = $name;
        }
        if($checked == "checked") {
            $attr['checked'] = $checked;
        }

        $checkbox .= '		
            <div class="form-check mb-3">
                '.form_checkbox($attr).'
                <label class="form-check-label" for="'.$row->field_id.'"> '.$row->field_text.'</label>
            </div>
        ';
    }

    return $label.$checkbox;
}

function checkbox($data) {
    $id = "";
    $name = "";
    $label = "";
    $mandatory = "";
    $value = "";
    $list = $data['list'];
    $checkbox = "";
        
    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id']."[]";
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }

    foreach($list as $row) {
        $checkedlist = explode("|", $value);
        $checked = "";
        foreach($checkedlist as $chk) {
            if($chk == $row) $checked = "checked";
        }

        $attr = array(
            'class' => 'form-check-input', 
            'value' => $row,
        );
        if($id != "") {
            $attr['id'] = $row;
        }
        if($name != "") {
            $attr['name'] = $name;
        }
        if($checked == "checked") {
            $attr['checked'] = $checked;
        }

        $checkbox .= '		
            <div class="form-check mb-3">
                '.form_checkbox($attr).'
                <label class="form-check-label" for="'.$row.'"> '.$row.'</label>
            </div>
        ';
    }

    return $label.$checkbox;
}

function selectPopup($data) {  
    $label = "";
    $mandatory = "";
    $id = array_key_exists('id', $data) ? $data['id'] : "";
    $column = array_key_exists('column', $data) ? $data['column'] : "";
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $text = array_key_exists('text', $data) ? $data['text'] : "";
    $class = array_key_exists('class', $data) ? $data['class'] : "";
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
        $value_text = $src->$text;
    }    

    $th = '<th class="width-15"></th>';
    if($column != "") {
        foreach($column as $col) {
            $th .= '<th class="'.$class.'">'.$col['field'].'</th>';
        }
    }

    $ret = $label.'
        <div class="input-group mb-3">
            <input type="hidden" id="'.$id.'" name="'.$id.'" value="'.$value.'" readonly="readonly" />
            <div class="input-group">
                <input type="text" id="'.$id.'_txt" name="'.$id.'_txt" class="form-control" aria-label="" aria-describedby="basic-addon2" readonly="readonly" value="'.$value_text.'">
                <span class="input-group-text bg-primary" id="basic-addon2">
                    <a class="xbutton" href="javascript:void(0)" data-bs-toggle="modal" style="color:#fff !important;" data-bs-target="#Dialog'.$id.'" onclick="selectpopup_'.$id.'()">'.str("button_open").'</a>
                </span>
            </div>
        </div>

        <div class="modal fade" id="Dialog'.$id.'" tabindex="-1" role="dialog" aria-labelledby="Dialog'.$id.'Label" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">'.str("select").'</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">   
                        <table id="Popup_'.$id.'" class="table table-striped table-border-bottom table-border-left-right-bottom" style="width:100%">
                            <thead><tr>'.$th.'</tr></thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    ';
    return $ret;
}

function inputEditor($data) {
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $label = "";
    $mandatory = "";

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }

    $attr = array(
        'class' => 'form-control summernote-init'
    );
    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($value != "") {
        $attr['value'] = $value;
    }

    $form = form_textarea($attr);
    return '
        <div class="mb-5">
            '.$label.$mandatory.'
            <div class="form-icon position-relative">
                '.$form.'
            </div>
        </div>
    ';
}

function uploadFile($data) {
    $id = "";
    $name = "";
    $value = "";
    $readonly = "";
    $placeholder = "";
    $label = "";
    $mandatory = "";

    if (array_key_exists('id', $data)) {
        $id = $data['id'];
        $name = $data['id'];
    }
    if (array_key_exists('name', $data)) {
        $name = $data['name'];
    }
    if (array_key_exists('value', $data)) {
        $value = $data['value'];
    }
    if (array_key_exists('mandatory', $data)) {
        $mandatory = $data['mandatory'];
    }
    if (array_key_exists('label', $data)) {
        if($mandatory != "")
            $label = label(["text" => $data['label'], "mandatory"=>1]);
        else
            $label = label(["text" => $data['label']]);
    }
    if (array_key_exists('src', $data)) {
        $src = $data['src'];
        $value = $src->$id;
    }

    $attr = array(
        'class' => 'form-control'
    );
    if($id != "") {
        $attr['id'] = $id;
    }
    if($name != "") {
        $attr['name'] = $name;
    }
    if($readonly != "") {
        $attr['readonly'] = $readonly;
    }
    if($placeholder != "") {
        $attr['placeholder'] = $placeholder;
    }

    $button_view = "";
    if($value != '') {
        $exp = explode('.', $value);
        $ext = $exp[1];

        if($ext == 'jpg' || $ext == 'jpeg' || $ext == 'png' || $ext == 'gif') {
            $button_view = '  
                <a class="btn btn-primary" href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#Dialog'.$id.'"><i class="fa fa-image"></i></a>              
                <div class="modal fade" id="Dialog'.$id.'" tabindex="-1" role="dialog" aria-labelledby="Dialog'.$id.'Label" aria-hidden="true">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">'.$data['label'].'</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">   
                                <img src="'.asset_uploaded().'/'.$value.'" class="img-upload" style="width:100%" />
                            </div>
                        </div>
                    </div>
                </div>';
        } else {            
            $button_view = '<a href="'.asset_uploaded().'/'.$value.'" target="_blank" class="btn btn-primary"><i class="fa fa-file"></i></a>';				
        }
    }

    $ret =  $label.'
        <div class="row">
            <div class="col-md-9">'.form_upload($attr).'</div>
            <div class="col-md-3">'.$button_view.'</div>
        </div>
        <input type="hidden" id="'.$id.'_old" name="'.$id.'_old" value="'.$value.'" />';   

    return $ret;
}

function saveImage($request, $par) {
    $file = $request->getFile($par);
    $file_name = $request->getPost($par."_old");
    if($file->getName() != "") {        
        $valid = 1;
        $msg = "";
        $file_name = $file->getRandomName();
        $file_size = $file->getSize('mb');
        $file_ext = strtoupper($file->getClientExtension());
        if($file_size <= 1126400) {
            if ($file_ext == 'JPG' || $file_ext == 'JPEG' || $file_ext == 'PNG' || $file_ext == 'GIF') {
                $file->move("uploaded", $file_name);
            } else {     
                $valid = 0;
                $msg = "Type of file must be JPG, JPEG, PNG and GIF";            
            } 
        } else {
            $valid = 0;
            $msg = "File size must be less than 1 MB";   
        }
        if($valid == 0) {
            $output = array(
                "sistemator_token" => csrf_hash(),
                "msg" => $msg,
                "status" => 0,
                "row_id" => 0,
            );
            echo json_encode($output);
            exit();
        }
    }    
    return $file_name;
}

function saveDocs($request, $par) {
    $file = $request->getFile($par);
    $file_name = $request->getPost($par."_old");
    if($file->getName() != "") {          
        $valid = 1;
        $msg = "";  
        $file_name = $file->getRandomName();
        $file_size = $file->getSize('mb');
        $file_ext = strtoupper($file->getClientExtension());
        if($file_size <= 6144000) {
            if ($file_ext == 'PDF' || $file_ext == 'DOCX' || $file_ext == 'DOC' || $file_ext == 'XLS' || $file_ext == 'XLSX' || $file_ext == 'CSV') {
                $file->move("uploaded", $file_name);
            } else {     
                $valid = 0;
                $msg = $msg;            
            } 
        } else {
            $valid = 0;
            $msg = "File size must be less than 5 MB";   
        }
        if($valid == 0) {
            $output = array(
                "sistemator_token" => csrf_hash(),
                "msg" => "Type of file must be PDF, DOCX, DOCX, XLS, XLSX and CSV",
                "status" => 0,
                "row_id" => 0,
            );
            echo json_encode($output);
            exit();
        }     
    }
    return $file_name;
}

?>