<?php

function button($data) 
{    
    $ret = "";
    foreach($data as $btn) {
        $id = array_key_exists('id', $btn) ? $btn['id'] : "";
        $url = array_key_exists('url', $btn) ? $btn['url'] : "javascript:void(0)";
        $onclick = array_key_exists('onclick', $btn) ? 'onclick="'.$btn['onclick'].'"' : "";
        $color = array_key_exists('color', $btn) ? "btn-".$btn['color'] : "btn-primary";
        $label = array_key_exists('label', $btn) ? $btn['label'] : "save";
        $access = array_key_exists('access', $btn) ? $btn['access'] : "";        

        if($access == "Full control") {
            $ret .= '<a href="'.$url.'" '.$onclick.' class="btn '.$color .' waves-effect waves-light ml-5 xbutton">'.$label.'</a>';
        } else {
            $ret .= '<span class="btn btn-disable btn-light mr-5 xbutton">'.$label.'</span>';
        }
    }
    return $ret;
}

function buttonTable($data) 
{
    $ret = "";
    foreach($data as $btn) {
        $id = array_key_exists('id', $btn) ? $btn['id'] : "";
        $url = array_key_exists('url', $btn) ? $btn['url'] : "javascript:void(0)";
        $onclick = array_key_exists('onclick', $btn) ? 'onclick="'.$btn['onclick'].'"' : "";
        $color = array_key_exists('color', $btn) ? "btn-".$btn['color'] : "btn-primary";
        $label = array_key_exists('label', $btn) ? $btn['label'] : "save";
        $access = array_key_exists('access', $btn) ? $btn['access'] : "";        

        if($access == "Full control") {
            $ret .= '<a href="'.$url.'" '.$onclick.' class="btn btn-sm '.$color .' waves-effect waves-light mr-5 xbutton_table">'.$label.'</a>';
        } else {
            $ret .= '<span class="btn-disable btn-sm btn-light mr-5 xbutton_table">'.$label.'</span>';
        }
    }
    return $ret;
}

function buttonTableLine($data) 
{
    $ret = "";
    foreach($data as $btn) {
        $id = array_key_exists('id', $btn) ? $btn['id'] : "";
        $url = array_key_exists('url', $btn) ? $btn['url'] : "javascript:void(0)";
        $onclick = array_key_exists('onclick', $btn) ? 'onclick="'.$btn['onclick'].'"' : "";
        $color = array_key_exists('color', $btn) ? "btn-".$btn['color'] : "btn-primary";
        $label = array_key_exists('label', $btn) ? $btn['label'] : "save";
        $access = array_key_exists('access', $btn) ? $btn['access'] : "";        

        if($access == "Full control") {
            $ret .= '<a href="javascript:void(0)" onclick="save_header(\''.$url.'\')" class="btn btn-sm '.$color .' waves-effect waves-light mr-5 xbutton_table">'.$label.'</a>';
        } else {
            $ret .= '<span class="btn-disable btn-sm btn-light mr-5 xbutton_table">'.$label.'</span>';
        }
    }
    return $ret;
}

function buttonLine($data) 
{    
    $id = array_key_exists('id', $data) ? $data['id'] : "";
    $url = array_key_exists('url', $data) ? $data['url'] : "javascript:void(0)";
    $label = array_key_exists('label', $data) ? $data['label'] : "save";
    $access = array_key_exists('access', $data) ? $data['access'] : "";  
    $color = array_key_exists('color', $data) ? "btn-".$data['color'] : "btn-dark";

    if($access == "Full control") {
        $ret = '<a href="javascript:void(0)" onclick="save_header(\''.$url.'\')" class="btn btn-sm '.$color.' waves-effect waves-light xbutton_table mr-5">'.$label.'</a>';
    } else {
        $ret = '<span class="btn-disable btn-sm btn-light mr-5 xbutton_table">'.$label.'</span>';
    }

    return $ret;
}

function linkView($data) 
{    
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $form_id = array_key_exists('form_id', $data) ? $data['form_id'] : "";
    $title = array_key_exists('title', $data) ? $data['title'] : "";
    $url = array_key_exists('url', $data) ? $data['url'] : "";  
    $width = array_key_exists('width', $data) ? $data['width'] : null;

    return '<a href="javascript:void(0)" onclick="link_view(\''.$form_id.'\', \''.$url.'\')"  class="link-action">'.$value.'</a>'.modal_view(["form_id" => $form_id, "title" => $title, "width" => $width]);
}

function modal_view($data) 
{
    $title = array_key_exists('title', $data) ? $data['title'] : "";
    $form_id = array_key_exists('form_id', $data) ? $data['form_id'] : "";
    $width = array_key_exists('width', $data) ? $data['width'] : null;
    
    $set_width = ($width == null) ? "" : 'style="min-width: '.$width.' !important"';

    return '
        <div id="modal_view_'.$form_id.'" class="modal fade" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" '.$set_width.'>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">'.$title.'</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" style="padding:0px !important; margin:0px !important;">
                        <div id="iframe_'.$form_id.'" class="modal-view"></div>
                    </div>
                </div>
            </div>
        </div>
    ';
}

function button_search() 
{
    return '<a href="javascript:void(0)" onclick="link_search()" class="btn btn-light waves-effect waves-light ml-5 right-bar-toggle xbutton">'.str("button_advanced_search").'</a>';
}

function button_selectpopup($data) 
{
    $field_id = array_key_exists('field_id', $data) ? $data['field_id'] : "";
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $text = array_key_exists('text', $data) ? $data['text'] : "";

    return '<a href="javascript:void(0)" data-bs-dismiss="modal" onclick="selected_modal(\''.$field_id.'\', \''.$value.'\', \''.$text.'\')" class="btn btn-sm btn-light xbutton">'.str("button_select").'</a>';
}

function breadcrumb($breadcrumb) 
{
    $navigation = '';
    foreach($breadcrumb as $row) {
        if (array_key_exists('url', $row)) {
            $navigation .= '
                <li class="breadcrumb-item"><a class="text-primary" href="'.$row['url'].'">'.$row['text'].'</a></li>
            ';
        } else {
            $navigation .= '
                <li class="breadcrumb-item active">'.$row['text'].'</li>
            ';
        }
    }

    return '
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between mb-3">
                    <div class="page-title-left">
                        <ol class="breadcrumb m-0">
                            '.$navigation.'
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    ';
}

function datatable($id, $data)
{
    $th = "";
    foreach($data as $row) {
        $class = array_key_exists('class', $row) ? $row['class'] : "";
        $text = array_key_exists('text', $row) ? $row['text'] : "";
        $th .= '<th class="'.$class.'">'.$text.'</th>';        
    }

    return '
        <table id="'.$id.'" class="table table-datatable table-hover" style="width:100%">
            <thead>
                <tr>'.$th.'</tr>
            </thead>
            <tbody></tbody>
        </table> 
    ';
}

function table($columns, $data)
{
    $ret = "";
    $th = "";
    $td = "";
    $i = 0;   

    foreach($columns as $col) {
        $class = array_key_exists('class', $col) ? $col['class'] : "";
        $text = array_key_exists('text', $col) ? $col['text'] : "";
        $th .= '<th class="'.$class.'">'.$text.'</th>'; 
        $i++;  
    }

    if(!empty($data)) {    
        foreach($data as $row) {
            $x = 1;
            foreach($row as $line) {
                $value = array_key_exists('value', $line) ? $line['value'] : "";
                if($x == 0) {
                    $td .= "<tr>";
                }
                $td .= '<td>'.$value.'</td>'; 
                if($x == $i) {
                    $td .= "</tr>";
                }
                $x++;
            }           
        }
    } else {    
        $td = '<tr><td colspan="'.$i.'" class="text-center">'.str("no_data").'</td></tr>';        
    }

    return '
        <table class="table border-bottom border-left border-right table-hover" style="width:100%">
            <thead>
                <tr>'.$th.'</tr>
            </thead>
            <tbody>'.$td.'</tbody>
        </table> 
    ';
}

function label($data) {
    $text = array_key_exists('text', $data) ? $data['text'] : "";
    $mandatory = array_key_exists('mandatory', $data) ? ' <span class="field-mandatory">*</span>' : "";
    return '<label class="form-label">'.$text.$mandatory.'</label>';
}

function printIcon($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    return '<i class="fa '.$value.'"></i>';
}

function printText($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    return $label.'<div class="form-label">'.$value.'</div>';
}

function printTextRaw($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    return $label.$value;
}


function printNumber($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    return $label.'
        <div class="form-label">'.number_format($value).'</div>    
    ';
}

function printMoney($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    return $label.'
        <div class="form-label">'.session()->get("currency").' '.number_format($value, 2).'</div>    
    ';
}

function printDate($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    return $label.'
        <div class="form-label"><span class="print-date">'.date("d-M-Y", strtotime($value)).'</span></div>    
    ';
}

function printDatetime($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    return $label.'<div class="form-label"><span class="print-date">'.date("d-M-Y H:i:s", strtotime($value)).'</span></div>';
}

function printNoYes($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    if($value == "YES") {
        $value = "YES";
    } else if($value == "NO") {
        $value = "NO";
    } else {
        $value = "NO";
    }
    
    $color = "";
    if($value == "NO") {
        $color = "danger";
    } else {
        $color = "success";
    }
    return $label.'<div class="form-label"><span class="badge bg-'.$color.' print-noyes">'.$value.'</span></div>';
}

function printCheckbox($data)
{
    $text = "";
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    if($value != "") {
        $list = explode('|', $value);
        $i = 1;
        $text = "<ul class='checkbox-list'>";
        foreach($list as $row) {
            $text .= "<li>".$row."</li>";
        }
        $text .= "</ul>";
    }
    return $label.'<div class="form-label">'.$text.'</div>';
}

function printCheckboxList($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    $list = array_key_exists('list', $data) ? $data['list'] : "";
    $text = "";
    if($value != "") {
        $value_list = explode('|', $value);
        $i = 1;
        $text = "<ul class='checkbox-list'>";
        foreach($value_list as $id) {
            $txt = "";
            if($list != "") {
                foreach($list as $line) {
                    if($line->field_id == $id) {
                        $txt = $line->field_text;
                    }
                }
                $text .= "<li>".$txt."</li>";
            }
        }
        $text .= "</ul>";
    }
    return $label.'
        <div class="form-label">'.$text.'</div>    
    ';
}

function printImage($data)
{
    $ret = "";
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    
    if($value != "") {
        $ret = '
            <div class="form-label">
                <a href="'.asset_uploaded().'/'.$value.'" target="_blank">
                    <img src="'.asset_uploaded().'/'.$value.'" class="print-image" style="width:100%" />
                </a>
            </div>  
        ';
    }
    return $label.$ret;
}

function printPDFImage($data)
{
    $ret = "";
    $value = array_key_exists('value', $data) ? $data['value'] : "";    
    $image = "";
    if($value !== "") {
        $file = FCPATH.'uploaded/'.$value;
        $type = pathinfo($file, PATHINFO_EXTENSION);
        $get_content = file_get_contents($file);
        $img = 'data:image/'.$type.';base64,'.base64_encode($get_content);
        $image = '<img class="photo" style="width:200px" src="'.$img.'" />';
    }
    return $image;
}

function printDocs($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    return $label.'
        <div class="form-label">
            <a href="'.asset_uploaded().'/'.$value.'" target="_blank" class="btn btn-primary"><i class="fa fa-file"></i></a>
        </div>    
    ';
}

function printPDFDocs($data)
{
    $ret = "";
    $value = array_key_exists('value', $data) ? $data['value'] : "";  
    return '<div class="form-label">'.$value.'</div>  ';
}

function printPassword($data)
{
    $value = array_key_exists('value', $data) ? $data['value'] : "";
    $label = array_key_exists('label', $data) ? '<label class="title-view">'.$data['label'].'</label>' : "";
    return $label.'<div class="form-label">*******</div>';
}

function formTitle($str)
{
    return '<h6 class="text-uppercase font-bold mb-3 mt-5">'.$str.'</h6>';
}

?>