<?php

namespace App\Models;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\Model;
use Config\Database;
use App\Entities\SysUserEntity;

class SysAuthModel extends Model
{
    protected $DBGroup = "default";
    protected $table = "sysuser";
    protected $primaryKey = "row_id";
    protected $useAutoIncrement = true;
	protected $insertID = 0;
	protected $returnType = "App\Entities\SysUserEntity";
	protected $useSoftDelete = false;
	protected $protectFields = true;
    protected $useTimestamps = false;
	protected $dateFormat = "datetime";
    protected $createdField = "";
    protected $updatedField = "";
    protected $deletedField = "";
	protected $skipValidation = false;
	protected $cleanValidationRules = true;
	protected $validationRules = [];
	protected $validationMessages = [];
    protected $db;
    protected $builder;
    protected $request;
    protected $order = ["row_id" => "DESC"];
    protected $allowedFields = [
        "row_id", 
        "user_access_id",
        "name",
        "title",
        "email",
        "user_id",
        "pswrd",
        "is_active",
        "is_deleted",
        "created_date",
        "created_by",
        "modified_date",
        "modified_by",
        "deleted_date",
        "deleted_by",
    ];
    protected $column_order = ["row_id"];
    protected $column_search = [
        "user_access_id_txt",
        "name",
        "title",
        "email",
        "user_id",
        "pswrd",
        "is_active",
    ];
    public $fieldValue = [
        "row_id" => 0,
        "user_access_id" => "",
        "name" => "",
        "title" => "",
        "email" => "",
        "user_id" => "",
        "pswrd" => "",
        "is_active" => "",
        "created_date" => "",
        "created_by" => "",
        "modified_date" => "",
        "modified_by" => "",
        "deleted_date" => "",
        "deleted_by",
    ];

    public function __construct(RequestInterface $request=null)
    {
        parent::__construct();
        $this->request = $request;
        $this->db = Database::connect();
        $this->builder = $this->db->table($this->table);
    }

    public function getSelect($where=null) 
    {
        $condition = "sysuser.is_deleted = 0";
		if ($where != null) {
		    $condition .= " and ".$where;
		}
        
        $this->builder->select("sysuser.*, user_access_id_table.name AS user_access_id_txt");
        $this->builder->join("sysuseraccess user_access_id_table", "user_access_id_table.row_id = sysuser.user_access_id", "left");
        $this->builder->where($condition);
        $query = $this->builder->get();
        $result = $query->getResultArray();
        if($result == null) {
            return (object)$this->fieldValue;
        } else {
		    $data = new SysUserEntity();
            $data->fill($result[0]);
            return $data;
        }
    } 

    public function getAuthLogin($data) 
    {        
        $user_id = array_key_exists("user_id", $data) ? $data["user_id"] : "";
        $this->builder->select("sysuser.*, user_access_id_table.name AS user_access_id_txt");
        $this->builder->join("sysuseraccess user_access_id_table", "user_access_id_table.row_id = sysuser.user_access_id", "left");
        $this->builder->where("sysuser.user_id", $user_id);
        $this->builder->where("sysuser.is_deleted", "0");
        $query = $this->builder->get();
        $result = $query->getResultArray();
        if($result == null) {
            return null;;
        } else {
            return $result[0];
        }
    }   
}