<?= $this->extend('web_layout/admin/lancements_layout') ?>

<?= $this->section('content') ?>

<?= inputHidden(["sistemator_token" => csrf_hash()]); ?>

<div class="row">

    <div class="col-sm-12">
        <div class="card card-h-100">
            <div class="card-body">

                <?php
                $column[] = ["text" => "ID", "class" => "width-3"];
                $column[] = ["text" => "Lancement", "class" => "width-20"];
                $column[] = ["text" => "Marque", "class" => "width-10"];
                $column[] = ["text" => "Préco", "class" => "width-3"];
                $column[] = ["text" => "Date Préco", "class" => "width-10"];
                $column[] = ["text" => "Préco Activée", "class" => "width-3"];
                $column[] = ["text" => "Date Lancement", "class" => "width-10"];
                $column[] = ["text" => "Date Récéption", "class" => "width-10"];
                $column[] = ["text" => "Statut", "class" => "width-10"];
                echo datatable("table", $column);
                ?>

            </div>
        </div>
    </div>


</div>





<?= $this->endSection() ?>

<?= $this->section('javascript') ?>
<style>
    .width-3 {
        width:3%!important;
    }
    .width-10 {
        width:10%!important;
    }
    .width-20 {
        width:20%!important;
    }
    input {
        width: 100%;
    }
    #filterRow input {
        width: 100%;
        box-sizing: border-box;
    }

    .dt-search {
        position: absolute;
        right: 0;
        margin-top: -20px;
    }

</style>
<script type="text/javascript">




    function page_load()
    {

        bind_table();
    }




    var where = "";
    var datatable;


    function bind_table()
    {
        var tableId = '#table';
        var url = '<?= admin_url($page_route.'/list') ?>';
        datatable = $(tableId).DataTable({
            "processing": true,
            "serverSide": false,
            "ordering": true,
            "pageLength": 50,
            order: [[0, 'desc']],
            "language": {
                     "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/French.json"
            },
            dom: 'lBfrtip',
            layout: {
                topStart: {
                    buttons: [
                        {
                            extend: 'excelHtml5',
                            title: 'Lancements'
                        },
                        {
                            extend: 'csvHtml5',
                            title: 'Lancements'
                        },
                        {
                            extend: 'pdfHtml5',
                            title: 'Lancements'
                        }

                    ]
                }
            },
            "ajax": {
                "url": url,
                "type": "POST",
                "data": function(data) {
                    data.sistemator_token = $("#sistemator_token").val();
                    data.where = where;
                },
                "dataSrc": function(response) {
                    $('#sistemator_token').val(response.sistemator_token);
                    return response.data;
                }
            },
            "initComplete": function() {
                var api = this.api();

                // Ajouter une rangée pour les champs de recherche
                $(tableId + ' thead').append('<tr id="filterRow"></tr>');

                // Ajouter un champ de recherche pour chaque colonne
                api.columns().every(function() {
                    var column = this;

                    // Ajout d'un <td> pour chaque champ
                    var input = $('<input type="text" class="form-control form-control-sm" placeholder="Recherche..." />')
                        .on('keyup change clear', function() {
                            if (column.search() !== this.value) {
                                column.search(this.value).draw();
                            }
                        });

                    // Insérer le champ de recherche dans un <td>
                    $('#filterRow').append($('<td></td>').append(input));
                });
            }/*,
            "initComplete": function () {
                var api = this.api();

                // Parcourir chaque colonne
                api.columns().every(function() {
                    var column = this;
                    var header = $(column.header());

                    // Ajouter un dropdown dans chaque colonne
                    var select = $('<select><option value="">Tous</option></select>')
                        .appendTo(header.empty()) // Vider l'en-tête avant d'ajouter le dropdown
                        .on('change', function() {
                            var val = $.fn.dataTable.util.escapeRegex($(this).val());

                            column
                                .search(val ? '^' + val + '$' : '', true, false) // Activer le filtrage avec Regex
                                .draw();
                        });

                    // Ajouter les options au dropdown en fonction des données uniques de la colonne
                    column.data().unique().sort().each(function(d) {
                        select.append('<option value="' + d + '">' + d + '</option>');
                    });
                });
            }
*/



        });




    }
    document.getElementById('input').addEventListener('click', function(e) {
        e.preventDefault();
        return true;
    });
</script>

<?= $this->endSection() ?>


