<?= $this->extend('web_layout/admin/lancements_layout') ?>

<?= $this->section('content') ?>

<?= inputHidden(["sistemator_token" => csrf_hash()]); ?>

<div class="container-wrapper mt-5">


    <form method="get" action="/admin/lancementsnow" class="mb-4">
        <div class="row">
            <div class="col-md-4">
                <label for="search_lancement" class="form-label">Rechercher un lancement</label>
                <input
                        type="text"
                        id="search_lancement"
                        name="search_lancement"
                        class="form-control"
                        value="<?= esc($search_lancement ?? '') ?>"
                        placeholder="Entrez un lancement">
            </div>
            <div class="col-md-4">
                <label for="search_marque" class="form-label">Rechercher une marque</label>
                <input
                        type="text"
                        id="search_marque"
                        name="search_marque"
                        class="form-control"
                        value="<?= esc($search_marque ?? '') ?>"
                        placeholder="Entrez une marque">
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">Rechercher</button>
            </div>
        </div>
    </form>




    <div class="accordion" id="lancementsAccordion">

        <!-- Accordéon pour "Lancement Effectué" -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingGreen">
                <button class="accordion-button bg-green text-white collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseGreen" aria-expanded="false" aria-controls="collapseGreen">
                    Lancement Effectué (<?= count(array_filter($lancements, fn($l) => trim($l['statut']) === '8 L - Lancement Effectué')) ?>)
                </button>
            </h2>
            <div id="collapseGreen" class="accordion-collapse collapse" aria-labelledby="headingGreen" data-bs-parent="#lancementsAccordion">
                <div class="accordion-body">
                    <table class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>Lancement</th>
                            <th>Marque</th>
                            <th>Date Lancement</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($lancements as $lancement): ?>
                            <?php if (in_array($lancement['statut'], ['8 L - Lancement Effectué'])): ?>
                                <tr class="toggle-row" data-target="#details-<?= $lancement['id'] ?>">
                                    <td><?= esc($lancement['lancement']) ?></td>
                                    <td><?= esc($lancement['marque']) ?></td>
                                    <td><?= esc($lancement['date_lancement']) ?></td>
                                </tr>
                                <tr id="details-<?= $lancement['id'] ?>" class="details-row d-none">
                                    <td colspan="3">
                                        <div class="row">
                                            <!-- Afficher la clé id_produit en premier -->
                                            <?php if (!empty($lancement['id_produit_details'])): ?>
                                                <div class="col-md-12 mb-3">
                                                    <label class="form-label">Produits associés</label>
                                                    <ul class="list-group">
                                                        <?php foreach ($lancement['id_produit_details'] as $product): ?>
                                                            <li class="list-group-item">
                                                                <strong><?= esc($product['product_title']) ?></strong><br>
                                                                Référence : <?= esc(!empty($product['attribute_reference']) ? $product['attribute_reference'] : $product['product_reference']) ?><br>
                                                                Stock : <?= esc($product['stock_quantity']) ?>

                                                            </li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Parcourir les autres clés en excluant id_produit_details -->
                                            <?php foreach ($lancement as $key => $value): ?>
                                                <?php
                                                // Liste des clés à exclure
                                                $excludedKeys = [
                                                    'id',
                                                    'lancement',
                                                    'date_lancement',
                                                    'marque',
                                                    'accessoires',
                                                    'first_batch',
                                                    'dispo_en_chine',
                                                    'pick_up',
                                                    'id_produit',
                                                    'samples_envoyes_marketing',
                                                    'goodies_plv',
                                                    'id_produit_details' // Éviter d'afficher deux fois
                                                ];

                                                if (in_array($key, $excludedKeys)) {
                                                    continue; // Passer cette clé
                                                }
                                                ?>
                                                <!-- Afficher tous les autres attributs -->
                                                <div class="col-md-4 mb-3">
                                                    <label class="form-label"><?= ucfirst(str_replace('_', ' ', $key)) ?></label>
                                                    <div class="form-control bg-light">
                                                        <?= is_scalar($value) ? esc($value) : '---' ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>

                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; ?>


                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Accordéon pour "Précommande en cours" -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingOrange">
                <button class="accordion-button bg-orange text-white collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOrange" aria-expanded="false" aria-controls="collapseOrange">
                    Précommande en cours (<?= count(array_filter($lancements, fn($l) => trim($l['statut']) === '6 L - Précommande en cours')) ?>)
                </button>
            </h2>
            <div id="collapseOrange" class="accordion-collapse collapse" aria-labelledby="headingOrange" data-bs-parent="#lancementsAccordion">
                <div class="accordion-body">
                    <table class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>Lancement</th>
                            <th>Marque</th>
                            <th>Date Lancement</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($lancements as $lancement): ?>
                            <?php if (in_array($lancement['statut'], ['6 L - Précommande en cours'])): ?>
                                <tr class="toggle-row" data-target="#details-<?= $lancement['id'] ?>">
                                    <td><?= esc($lancement['lancement']) ?></td>
                                    <td><?= esc($lancement['marque']) ?></td>
                                    <td><?= esc($lancement['date_lancement']) ?></td>
                                </tr>
                                <tr id="details-<?= $lancement['id'] ?>" class="details-row d-none">
                                    <td colspan="3">
                                        <div class="row">
                                            <!-- Afficher la clé id_produit en premier -->
                                            <?php if (!empty($lancement['id_produit_details'])): ?>
                                                <div class="col-md-12 mb-3">
                                                    <label class="form-label">Produits associés</label>
                                                    <ul class="list-group">
                                                        <?php foreach ($lancement['id_produit_details'] as $product): ?>
                                                            <li class="list-group-item">
                                                                <strong><?= esc($product['product_title']) ?></strong><br>
                                                                Référence : <?= esc(!empty($product['attribute_reference']) ? $product['attribute_reference'] : $product['product_reference']) ?><br>
                                                                Stock : <?= esc($product['stock_quantity']) ?>
                                                            </li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Parcourir les autres clés en excluant id_produit_details -->
                                            <?php foreach ($lancement as $key => $value): ?>
                                                <?php
                                                // Liste des clés à exclure
                                                $excludedKeys = [
                                                    'id',
                                                    'lancement',
                                                    'date_lancement',
                                                    'marque',
                                                    'accessoires',
                                                    'first_batch',
                                                    'dispo_en_chine',
                                                    'pick_up',
                                                    'id_produit',
                                                    'samples_envoyes_marketing',
                                                    'goodies_plv',
                                                    'goodies_plv',
                                                    'id_produit_details' // Éviter d'afficher deux fois
                                                ];

                                                if (in_array($key, $excludedKeys)) {
                                                    continue; // Passer cette clé
                                                }
                                                ?>
                                                <!-- Afficher tous les autres attributs -->
                                                <div class="col-md-4 mb-3">
                                                    <label class="form-label"><?= ucfirst(str_replace('_', ' ', $key)) ?></label>
                                                    <div class="form-control bg-light">
                                                        <?= is_scalar($value) ? esc($value) : '---' ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; ?>



                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Accordéon pour tous les autres statuts -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingGray">
                <button class="accordion-button bg-gray text-white collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseGray" aria-expanded="false" aria-controls="collapseGray">
                    Autres Statuts (<?= count(array_filter($lancements, fn($l) => !in_array(trim($l['statut']), ['8 L - Lancement Effectué', '6 L - Précommande en cours']))) ?>)
                </button>
            </h2>
            <div id="collapseGray" class="accordion-collapse collapse" aria-labelledby="headingGray" data-bs-parent="#lancementsAccordion">
                <div class="accordion-body">
                    <table class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>Lancement</th>
                            <th>Marque</th>
                            <th>Date Lancement</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($lancements as $lancement): ?>
                            <?php if (!in_array(trim($lancement['statut']), ['8 L - Lancement Effectué', '6 L - Précommande en cours'])): ?>
                                <tr class="toggle-row" data-target="#details-<?= $lancement['id'] ?>">
                                    <td><?= esc($lancement['lancement']) ?></td>
                                    <td><?= esc($lancement['marque']) ?></td>
                                    <td><?= esc($lancement['date_lancement']) ?></td>
                                </tr>
                                <tr id="details-<?= $lancement['id'] ?>" class="details-row d-none">
                                    <td colspan="3">
                                        <div class="row">
                                            <!-- Afficher la clé id_produit en premier -->
                                            <?php if (!empty($lancement['id_produit_details'])): ?>
                                                <div class="col-md-12 mb-3">
                                                    <label class="form-label">Produits associés</label>
                                                    <ul class="list-group">
                                                        <?php foreach ($lancement['id_produit_details'] as $product): ?>
                                                            <li class="list-group-item">
                                                                <strong><?= esc($product['product_title']) ?></strong><br>
                                                                Référence : <?= esc(!empty($product['attribute_reference']) ? $product['attribute_reference'] : $product['product_reference']) ?><br>
                                                                Stock : <?= esc($product['stock_quantity']) ?>
                                                            </li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Parcourir les autres clés en excluant id_produit_details -->
                                            <?php foreach ($lancement as $key => $value): ?>
                                                <?php
                                                // Liste des clés à exclure
                                                $excludedKeys = [
                                                    'id',
                                                    'lancement',
                                                    'date_lancement',
                                                    'marque',
                                                    'accessoires',
                                                    'first_batch',
                                                    'dispo_en_chine',
                                                    'pick_up',
                                                    'id_produit',
                                                    'samples_envoyes_marketing',
                                                    'goodies_plv',
                                                    'id_produit_details' // Éviter d'afficher deux fois
                                                ];

                                                if (in_array($key, $excludedKeys)) {
                                                    continue; // Passer cette clé
                                                }
                                                ?>
                                                <!-- Afficher tous les autres attributs -->
                                                <div class="col-md-4 mb-3">
                                                    <label class="form-label"><?= ucfirst(str_replace('_', ' ', $key)) ?></label>
                                                    <div class="form-control bg-light">
                                                        <?= is_scalar($value) ? esc($value) : '---' ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; ?>


                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script>
    $(document).ready(function () {
        // Gestion des lignes togglables
        $('.toggle-row').on('click', function () {
            const target = $($(this).data('target'));
            $(this).closest('tbody').find('.details-row').not(target).addClass('d-none');
            target.toggleClass('d-none');
        });
    });
</script>

<style>
    .bg-green {
        background-color: green !important;
        color: white !important;
    }
    .bg-orange {
        background-color: orange !important;
        color: white !important;
    }
    .bg-gray {
        background-color: #6c757d !important;
        color: white !important;
    }
    .form-label {
        font-weight: bold;
    }
    .form-control {
        border: none;
        box-shadow: none;
    }
    .toggle-row {
        cursor: pointer;
    }
</style>

<?= $this->endSection() ?>
