<?= $this->extend('web_layout/admin/form_layout') ?>

<?= $this->section('content') ?>

<?php
    $list[] = ["text" => $page_title, "url" => admin_url($page_route)];
    $list[] = ["text" => str("form")];
    echo breadcrumb($list);
?>

<div class="row">
    <?php                            
        echo form_open_multipart(admin_url($page_route."/save"), ["id" => "form_input"]);
        echo inputHidden(["sistemator_token" => csrf_hash()]);
        echo inputHidden(["row_id" => $row_id]);
    ?>
    <div class="col-12">
        <div class="row">
            <div class="col-md-4 mb-5">
                <?= inputText(["src" => $data, "id" => "folder_name", "label" => str("sysmenu_folder_name"), "mandatory" => 1]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= inputNumber(["src" => $data, "id" => "seq", "label" => str("sysmenu_seq"), "mandatory" => 1]); ?>
            </div>
            <div class="col-md-4 mb-5">            
                <?php                    
                    $columns[] = ["field" => "Img", "class" => "width-15"];
                    $columns[] = ["field" => str("sysmenu_icon"), "class" => "width-70"];
                    echo selectPopup(["src" => $data, "id" => "icon", "label" => str("sysmenu_icon"), "text" => "icon_txt", "column" => $columns]);
                ?>
            </div>
        </div>
    </div>  
    <div class="col-12">
        <div class="row">
            <div class="col-md-12 mt-3 border-left">   
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#table_list" role="tab">List</a></li>
                </ul>
                <div class="tab-content pt-3">
                    <div class="tab-pane active" id="table_list" role="tabpanel">
                        <?= $table_list ?>  
                    </div>
                </div>           
            </div>
        </div>
    </div>  
    <?= form_close() ?>     
</div>   

<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    function page_load() {
        
    }

    function validation() {
        var ret = true;
        if($("#folder_name").val() == "") {error("Folder must be filled"); ret = false}
        if($("#seq").val() == "") {error("Sequence must be filled"); ret = false}
        if($("#icon").val() == "") {error("Icon must be filled"); ret = false}
        return ret;
    }

    function deleteSysMenu() {
        var csrf = $("#sistemator_token").val();
        var url = "<?= admin_url($page_route) ?>/delete/";
        var id = $("#row_id").val();
        exec_delete(csrf, url, id);          
    }

    function after_exec(ret) {
        var url = "<?= admin_url($page_route) ?>";
        var data = JSON.parse(ret); 
        var msg = data["msg"];
        var status = data["status"];
        var token = data["sistemator_token"];
        $("#sistemator_token").val(token);

        if(status == 1) {
            success(msg, url); 
        } else {
            error(msg);              
        }
    }
    
    function selectpopup_icon() {
        var tableId = "#Popup_icon";
        var url = "<?= admin_url("select-popup/icon") ?>";
        var where = "";
        var field_id = "icon";
        $(tableId).dataTable().fnDestroy()
        var datatable = $(tableId).DataTable({ 
            "processing": true, 
            "serverSide": true, 
            "ordering": false,
            "dom": "t<\"bottom datatable-ext\"fp>",
            "ajax": {
                "url": url,
                "type": "POST",
                "data": function(data) {
                    data.sistemator_token = $("#sistemator_token").val();
                    data.where = where;
                    data.field_id = field_id;
                },
                "dataSrc": function(response) {
                    $("#sistemator_token").val(response.sistemator_token);                
                    return response.data;
                }
            }
        });   
    } 
    
</script>

<?= $this->endSection() ?>