function auth(form_id, button_id) 
{
    if(validation()) {
        exec(form_id, button_id);
    }
}

function save(form_id, button_id) 
{
    if(validation()) {
        Swal.fire({
            html: "Are you sure?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#2ab57d",
            cancelButtonColor: "#fd625e",
            confirmButtonText: "YES",
            cancelButtonText: "NO",
            customClass: {
                confirmButton: 'btn btn-sm btn-swal',
                closeButton: 'btn btn-sm btn-swal',
                cancelButton: 'btn btn-sm btn-swal',
                popup: 'container-confirm',
                icon: 'icon-alert',
            },
          }).then(function (result) {
            if (result.value) {
                exec(form_id, button_id);
            }
        });
    }
}

function save_header(destination)
{
    if(validation()) {
        exec_save_header(destination);
    }

}

function exec(formId, buttonId) 
{    
    var data = new FormData(document.getElementById(formId));
    var url = document.getElementById(formId).action;

    $(buttonId).prop("disabled", true);
    $(buttonId).addClass("btn-processing");
    $(buttonId).html("Loading...");
    $("#loading_bar").addClass("loading-show");

    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: url,
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        success: function (ret) {
            after_exec(ret);
            $("#loading_bar").removeClass("loading-show");
        },
        error: function (e) {
            error(e.responseText);
            $("#loading_bar").removeClass("loading-show");
        }
    });
}

function exec_save_header(destination) 
{
    var formId = "form_input";
    var data = new FormData(document.getElementById(formId));
    var url = document.getElementById(formId).action;

    $("#loading_bar").addClass("loading-show");

    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: url,
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        success: function (ret) {
            var data = JSON.parse(ret); 
            var row_id = data["row_id"];
            window.location.href = destination + row_id;
            $("#loading_bar").removeClass("loading-show");
        },
        error: function (e) {
            error(e.responseText);
            $("#loading_bar").removeClass("loading-show");
        }
    });
}

function exec_delete(csrf, url, id) 
{
    Swal.fire({
        html: "Are you sure?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#2ab57d",
        cancelButtonColor: "#fd625e",
        confirmButtonText: "YES",
        cancelButtonText: "NO",
        customClass: {
            confirmButton: 'btn btn-sm btn-swal',
            closeButton: 'btn btn-sm btn-swal',
            cancelButton: 'btn btn-sm btn-swal',
            popup: 'container-confirm',
            icon: 'icon-alert',
        },
        }).then(function (result) {
        if (result.value) {
            $("#loading_bar").addClass("loading-show");
            $.ajax({
                type: "GET",
                url: url,
                data: {
                    "sistemator_token": csrf,
                    "id": id, 
                },
                success: function (ret) {
                    $("#loading_bar").removeClass("loading-show");
                    after_exec(ret);
                },
                error: function (e) {
                    error(e.responseText);
                    $("#loading_bar").removeClass("loading-show");
                }
            });
        }
    });
}

function message(msg) 
{
    Swal.fire({
        html: msg,
        customClass: {
            confirmButton: 'btn-sm alert-button',
            popup: 'container-alert',
        },
    })
}

function error(msg) 
{
    Swal.fire({
        html: msg,
        icon: 'error',
        confirmButtonColor: "#fd625e",
        confirmButtonText: "OK",
        customClass: {
            confirmButton: 'btn btn-sm btn-swal',
            closeButton: 'btn btn-sm btn-swal',
            cancelButton: 'btn btn-sm btn-swal',
            popup: 'container-alert',
            icon: 'icon-alert',
        },
    })
}

function success(msg, redirect=null) 
{
    var timerInterval;
    Swal.fire({
        icon: 'success',
        timer: 1500,
        customClass: {
            confirmButton: 'alert-button-disable',
            closeButton: 'alert-button-disable',
            cancelButton: 'alert-button-disable',
            popup: 'container-success',
        },
        didOpen:function () {
            timerInterval = setInterval(function() {
            var content = Swal.getHtmlContainer()
            if (content) {
                var b = content.querySelector('b')
                if (b) {
                    b.textContent = Swal.getTimerLeft()
                }
            }
            }, 100)
        },
        onClose: function () { 
            clearInterval(timerInterval);
        }
    }).then(function (result) {
        if (result.dismiss === Swal.DismissReason.timer) {
            if(redirect == null) {                
                clearInterval(timerInterval)
            } else {
                clearInterval(timerInterval)
                window.location.href = redirect;
            }
        }
    })
}

function selected_modal(id, value_id, value_txt) 
{
    $("#"+id).val(value_id);
    $("#"+id+"_txt").val(value_txt);
    modal_after_select(id);
}

function formating_number(n) 
{
    return n.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",")
}

function format_currency(input, blur) 
{
    var curr = "";
    var input_val = input.val();
    if (input_val === "") { return; }
    var original_len = input_val.length;
    var caret_pos = input.prop("selectionStart");

    if (input_val.indexOf(".") >= 0) {
        var decimal_pos = input_val.indexOf(".");
        var left_side = input_val.substring(0, decimal_pos);
        var right_side = input_val.substring(decimal_pos);
        left_side = formating_number(left_side);
        right_side = formating_number(right_side);
        if (blur === "blur") {
            right_side += "000";
        }
        right_side = right_side.substring(0, 3);
        input_val = curr + left_side + "." + right_side;
    } else {
        input_val = formating_number(input_val);
        input_val = curr + input_val;
        if (blur === "blur") {
            input_val += ".000";
        }
    }
    input.val(input_val);
    var updated_len = input_val.length;
    caret_pos = updated_len - original_len + caret_pos;
    input[0].setSelectionRange(caret_pos, caret_pos);
}