﻿function get_datachart(url, data) {
    $.ajax({
        url: url,
        type: "GET",
        data: JSON.stringify(data),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        async: false,
        success: function (response) {
            ret = response;
        },
        error: function (e) {
            console.log(e.responseText);
            alert("Error dashboard");
        }
    });
    return ret;
}

function draw_pie(seriesData, id, Text, SerieName) {
    Highcharts.chart(id, {
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            type: 'pie'
        },
        title: {
            text: Text
        },
        tooltip: {
            pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: false
                },
                showInLegend: true
            }
        },
        series: [{
            name: SerieName,
            colorByPoint: true,
            data: seriesData
        }]
    });
}

function draw_halfpie(seriesData, id, Text, SerieName) {
    Highcharts.chart(id, {
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: 0,
            plotShadow: false,
            type: 'pie'
        },
        title: {
        text: Text,
        align: 'center',
        verticalAlign: 'middle',
        y: 40
        },
        tooltip: {
            pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        },
        plotOptions: {
            pie: {
                dataLabels: {
                    enabled: true,
                    distance: -50,
                    style: {
                        fontWeight: 'bold',
                        color: 'white'
                    }
                },
                startAngle: -90,
                endAngle: 90,
                center: ['50%', '75%']
            }
        },
        series: [{
            name: SerieName,
            colorByPoint: true,
            data: seriesData
        }]
    });
}

function draw_line(Categories, Series, id, Text, SerieName) {
    Highcharts.chart(id, {
        chart: {
            type: 'line'
        },
        title: {
            text: Text
        },
        xAxis: {
            categories: Categories
        },
        yAxis: {
            title: {
                text: SerieName
            }
        },
        plotOptions: {
            line: {
                dataLabels: {
                    enabled: true
                },
                enableMouseTracking: false
            }
        },
        series: Series
    });
}

function draw_bar(Categories, Series, id, Text, SerieName) {
    Highcharts.chart(id, {
        chart: {
            type: 'bar'
        },
        title: {
            text: Text
        },
        xAxis: {
            categories: Categories,
            crosshair: true
        },
        yAxis: {
            min: 0,
            title: {
                text: SerieName
            }
        },
        tooltip: {
            headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                '<td style="padding:0"><b>{point.y:.1f}</b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true
        },
        plotOptions: {
            series: {
                stacking: 'normal'
            }
        },
        series: Series
    });
}

function draw_column(Categories, Series, id, Text, SerieName) {
    Highcharts.chart(id, {
        chart: {
            type: 'column'
        },
        title: {
            text: Text
        },
        xAxis: {
            categories: Categories,
            crosshair: true
        },
        yAxis: {
            min: 0,
            title: {
                text: SerieName
            }
        },
        tooltip: {
            headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                '<td style="padding:0"><b>{point.y:.1f}</b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true
        },
        plotOptions: {
            column: {
                pointPadding: 0.2,
                borderWidth: 0
            }
        },
        series: Series
    });
}

function draw_area(Series, id, Text, SerieName) {
    Highcharts.chart(id, {
        chart: {
            type: 'area'
        },
        title: {
            text: Text
        },
        xAxis: {
            allowDecimals: false,
            labels: {
                formatter: function () {
                    return this.value; // clean, unformatted number for year
                }
            }
        },
        yAxis: {
            title: {
                text: SerieName
            },
            /*labels: {
                formatter: function () {
                    return this.value / 1000 + 'k';
                }
            }*/
        },
        tooltip: {
            pointFormat: '{series.name} had stockpiled <b>{point.y:,.0f}</b><br/>warheads in {point.x}'
        },
        plotOptions: {
            area: {
                pointStart: 1940,
                marker: {
                    enabled: false,
                    symbol: 'circle',
                    radius: 2,
                    states: {
                        hover: {
                            enabled: true
                        }
                    }
                }
            }
        },
        series: Series
    });
}

function draw_speedometer(value, max, suffix, id, Text) {
    Highcharts.chart(id, {
        chart: {
            type: 'solidgauge'
        },
        pane: {
            center: ['50%', '85%'],
            size: '100%',
            startAngle: -90,
            endAngle: 90,
            background: {
                innerRadius: '60%',
                outerRadius: '100%',
                shape: 'arc'
            }
        },
        title: {
            text: Text
        },
        yAxis: {
            min: 0,
            max: max,
        },
        tooltip: {
            enabled: false
        },
        plotOptions: {
            solidgauge: {
                dataLabels: {
                    y: 5,
                    borderWidth: 0,
                    useHTML: true
                }
            }
        },
        series: [{
            name: Text,
            data: [value],
            dataLabels: {
                format: '<div style="text-align:center"><span style="font-size:45px;color:' +
                    ((Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black') + '">{y}</span><br/>' +
                    '<span style="font-size:12px;color:silver">' + suffix + '</span></div>'
            },
            tooltip: {
                valueSuffix: suffix
            }
        }]
    });
}

function decimal_2(num) {
    return (Math.round(num * 100) / 100).toFixed(2)
}