<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'SysAuth::index');

$routes->group('docs', function($routes)
{
    $routes->get('/', 'Docs::index');
});

$routes->group('auth', function($routes)
{
    $routes->get('/', 'SysAuth::index');
    $routes->get('login', 'SysAuth::login');
    $routes->get('please-login', 'SysAuth::pleaseLogin');
    $routes->get('logout', 'SysAuth::logout');
    $routes->post('save-login', 'SysAuth::saveLogin');
    $routes->get('reset-password', 'SysAuth::re');
});

$routes->group('admin', ['filter' => 'check_login'], function($routes)
{
    $routes->post("select-popup/menu_id","SysSelectPopup::menu_id");

    $routes->get('dashboard','Dashboard::index');
    $routes->get('dashboard/get-monthly-product/','Dashboard::getMonthlyProduct');
    $routes->get('dashboard/get-achievement/','Dashboard::getAchievement');
    $routes->get('dashboard/get-portion/','Dashboard::getPortion');


    $routes->get('lancements','Lancements::index');
    $routes->get('lancements/get-monthly-product/','Lancements::getMonthlyProduct');
    $routes->get('lancements/get-achievement/','Lancements::getAchievement');
    $routes->get('lancements/get-portion/','Lancements::getPortion');
    $routes->post('lancements/list','Lancements::datatable');

    $routes->get('newuser', 'User::index');
    $routes->get('newuser/display', 'User::display');
    $routes->post('newuser/import', 'User::import');

    $routes->get('clients', 'Clients::index');
    $routes->get('clients/display', 'Clients::display');
    $routes->post('clients/import', 'Clients::import');



    $routes->get('sales','Sales::index');
    $routes->get('sales/form/(:any)','Sales::form/$1');
    $routes->get('sales/preview/(:any)','SysPreview::Sales/$1');
    $routes->get('sales/print/(:any)','Sales::print/$1');
    $routes->get('sales/excel/','Sales::excel');
    $routes->get('sales/delete/','Sales::delete');
    $routes->post('sales/list','Sales::datatable');
    $routes->post('sales/save/','Sales::save');
    $routes->post("select-popup/customer_id","SysSelectPopup::customer_id");

    $routes->get('product','Product::index');
    $routes->get('product/form/(:any)','Product::form/$1');
    $routes->get('product/preview/(:any)','SysPreview::Product/$1');
    $routes->get('product/print/(:any)','Product::print/$1');
    $routes->get('product/excel/','Product::excel');
    $routes->get('product/delete/','Product::delete');
    $routes->post('product/list','Product::datatable');
    $routes->post('product/save/','Product::save');

    $routes->get('customer','Customer::index');
    $routes->get('customer/form/(:any)','Customer::form/$1');
    $routes->get('customer/preview/(:any)','SysPreview::Customer/$1');
    $routes->get('customer/print/(:any)','Customer::print/$1');
    $routes->get('customer/excel/','Customer::excel');
    $routes->get('customer/delete/','Customer::delete');
    $routes->post('customer/list','Customer::datatable');
    $routes->post('customer/save/','Customer::save');

    $routes->get('user-access','SysUserAccess::index');
    $routes->get('user-access/form/(:any)','SysUserAccess::form/$1');
    $routes->get('user-access/preview/(:any)','SysPreview::SysUserAccess/$1');
    $routes->get('user-access/print/(:any)','SysUserAccess::print/$1');
    $routes->get('user-access/excel/','SysUserAccess::excel');
    $routes->get('user-access/delete/','SysUserAccess::delete');
    $routes->post('user-access/list','SysUserAccess::datatable');
    $routes->post('user-access/save/','SysUserAccess::save');
    $routes->get('user-access/form-access/(:any)/(:any)','SysUserAccess::formAccess/$1/$2');
    $routes->get('user-access/delete-access/','SysUserAccess::deleteAccess');
    $routes->post('user-access/save-access/','SysUserAccess::saveAccess');

    $routes->get('menu','SysMenu::index');
    $routes->get('menu/form/(:any)','SysMenu::form/$1');
    $routes->get('menu/preview/(:any)','SysPreview::SysMenu/$1');
    $routes->get('menu/print/(:any)','SysMenu::print/$1');
    $routes->get('menu/excel/','SysMenu::excel');
    $routes->get('menu/delete/','SysMenu::delete');
    $routes->post('menu/list','SysMenu::datatable');
    $routes->post('menu/save/','SysMenu::save');
    $routes->get('menu/form-list/(:any)/(:any)','SysMenu::formList/$1/$2');
    $routes->get('menu/delete-list/','SysMenu::deleteList');
    $routes->post('menu/save-list/','SysMenu::saveList');

    $routes->get('icon','SysIcon::index');
    $routes->get('icon/form/(:any)','SysIcon::form/$1');
    $routes->get('icon/preview/(:any)','SysPreview::SysIcon/$1');
    $routes->get('icon/print/(:any)','SysIcon::print/$1');
    $routes->get('icon/excel/','SysIcon::excel');
    $routes->get('icon/delete/','SysIcon::delete');
    $routes->post('icon/list','SysIcon::datatable');
    $routes->post('icon/save/','SysIcon::save');
    $routes->post("select-popup/icon","SysSelectPopup::icon");

    $routes->get('user', 'SysUser::index');
    $routes->get('user/form/(:any)', 'SysUser::form/$1');
    $routes->get('user/preview/(:any)', 'SysPreview::SysUser/$1');
    $routes->get('user/delete/', 'SysUser::delete');
    $routes->post('user/list','SysUser::datatable');
    $routes->post('user/save/', 'SysUser::save');
    
    $routes->get('language-primary', 'SysLanguage::primary');
    $routes->get('language-secondary', 'SysLanguage::secondary');

    $routes->get('web-info', 'SysWebInfo::index');
    $routes->get('web-info/form/(:any)', 'SysWebInfo::form/$1');
    $routes->post('web-info/save/', 'SysWebInfo::save');

    $routes->get('generator-header-detail', 'SysGeneratorHD::index');
    $routes->post('generator-header-detail/list', 'SysGeneratorHD::datatable');
    $routes->get('generator-header-detail/get-fields', 'SysGeneratorHD::getFields');
    $routes->get('generator-header-detail/form/(:any)', 'SysGeneratorHD::form/$1');
    $routes->get('generator-header-detail/generate/(:any)', 'SysGeneratorHD::generate/$1');  
    $routes->get('generator-header-detail/form-fields/(:any)/(:any)', 'SysGeneratorHD::formFields/$1/$2'); 
    $routes->get('generator-header-detail/form-details/(:any)/(:any)', 'SysGeneratorHD::formDetails/$1/$2'); 
    $routes->get('generator-header-detail/delete-fields/', 'SysGeneratorHD::deleteFields');
    $routes->get('generator-header-detail/delete-details/', 'SysGeneratorHD::deleteDetails');
    $routes->post('generator-header-detail/save', 'SysGeneratorHD::save'); 
    $routes->post('generator-header-detail/save-fields', 'SysGeneratorHD::saveFields'); 
    $routes->post('generator-header-detail/save-details', 'SysGeneratorHD::saveDetails'); 

    $routes->get('generator-master', 'SysGenerator::index');
    $routes->post('generator-master/list','SysGenerator::datatable');
    $routes->get('generator-master/form/(:any)', 'SysGenerator::form/$1');
    $routes->get('generator-master/get-fields', 'SysGenerator::getFields');
    $routes->get('generator-master/generate/(:any)', 'SysGenerator::generate/$1');  
    $routes->get('generator-master/form-fields/(:any)/(:any)', 'SysGenerator::formFields/$1/$2'); 
    $routes->post('generator-master/save', 'SysGenerator::save'); 
    $routes->post('generator-master/save-fields', 'SysGenerator::saveFields'); 

    $routes->get('home', 'SysHome::index');
    $routes->get('edit-profile', 'SysHome::editProfile');
    $routes->get('change-password', 'SysHome::changePassword');
    $routes->post('save-edit-profile', 'SysHome::saveEditProfile');
    $routes->post('save-change-password', 'SysHome::saveChangePassword');

    $routes->get('/', 'SysHome::index');
	
    $routes->get('contoh','Contoh::index');
    $routes->get('contoh/form/(:any)','Contoh::form/$1');
    $routes->get('contoh/preview/(:any)','SysPreview::Contoh/$1');
    $routes->get('contoh/print/(:any)','Contoh::print/$1');
    $routes->get('contoh/excel/','Contoh::excel');
    $routes->get('contoh/delete/','Contoh::delete');
    $routes->post('contoh/save/','Contoh::save');

    $routes->get('export-douanes-italie', 'ExportDouanesItalie::index');
    $routes->post('export-douanes-italie/export', 'ExportDouanesItalie::export');



    $routes->get('lancementsnow', 'LancementsNowController::index');

    $routes->get('cron/sync-prestashop-products', 'CronPrestashopProductsController::syncPrestashopProducts');



});
