<?php

namespace App\Controllers;

use App\Models\GeneralModel;
use App\Models\DashboardModel;
use App\Models\SalesModel;
use App\Entities\SalesEntity;
use App\Controllers\BaseController;
use Config\Services;
use CodeIgniter\Exceptions\PageNotFoundException;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Dashboard extends BaseController
{
	private $page_controller = "dashboard";
	private $page_route = "dashboard";

	public function index()
	{		
		$model = new SalesModel();
		$sales_list = $model->getList();

		$dashboard_model = new DashboardModel();

		$output = [
			"page_controller" => $this->page_controller,
			"page_route" => $this->page_route,
			"page_button" => "",
			"page_title" => "Dashboard",
			"sales_list" => $sales_list,
			"total" => $dashboard_model->getAchievement()
		];
		echo view("dashboard/index", $output);
	}

	public function getMonthlyProduct() 
	{
		$model = new DashboardModel();
        $data = $model->getMonthlyProduct();
        echo json_encode($data);
    }

    public function getPortion() 
	{
		$model = new DashboardModel();
        $data = $model->getPortion();
        echo json_encode($data);
    }

    public function getAchievement() 
	{
		$model = new DashboardModel();
        $data = $model->getAchievement();
        echo json_encode($data);
    }
}
