<?php

namespace App\Controllers;

use App\Models\GeneralModel;
use App\Models\DashboardModel;
use App\Models\LancementsModel;
use App\Models\LcaLancementsModel;
use App\Models\SalesModel;
use App\Entities\SalesEntity;
use App\Controllers\BaseController;
use Config\Services;
use CodeIgniter\Exceptions\PageNotFoundException;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Lancements extends BaseController
{
	private $page_controller = "lancements";
	private $page_route = "lancements";

	public function index()
	{		
		$model = new SalesModel();
		$sales_list = $model->getList();

		$dashboard_model = new LancementsModel();

		$output = [
			"page_controller" => $this->page_controller,
			"page_route" => $this->page_route,
			"page_button" => "",
			"page_title" => "Lancements",
			"sales_list" => $sales_list,
			"total" => $dashboard_model->getAchievement()
		];
		echo view("lancements/index", $output);
	}

	public function getMonthlyProduct() 
	{
		$model = new LancementsModel();
        $data = $model->getMonthlyProduct();
        echo json_encode($data);
    }

    public function getPortion() 
	{
		$model = new LancementsModel();
        $data = $model->getPortion();
        echo json_encode($data);
    }

    public function getAchievement() 
	{
		$model = new LancementsModel();
        $data = $model->getAchievement();
        echo json_encode($data);
    }


    public function datatable()
    {
        $request = Services::request();
        $sales_model = new LcaLancementsModel($request);
        $where = $request->getPost('where');
        $list = $sales_model->getDatatables($where);
        $no = $request->getPost('start');
        $data = [];

        foreach ($list as $lines) {
            $row_id = enkripsi($lines["id"]);
            $line = new SalesEntity();
            $line->fill($lines);

            $date_lancement = $line->date_lancement;
            if($date_lancement){
                $date_lancement = date("d-m-Y", strtotime($date_lancement));
            }

            $date_preco = $line->date_preco;
            if($date_preco){
                $date_preco = date("d-m-Y", strtotime($date_preco));
            }

            $date_reception = $line->date_reception;
            if($date_reception){
                $date_reception = date("d-m-Y", strtotime($date_reception));
            }

            $lancement = mb_strimwidth($line->lancement, 0, 50, '...');


            $lancement = $lancement.'<br><small>'.$line->staff.'</small>';
            $row = [];
            $row[] = printTextRaw(["value" => $line->id]);
            $row[] = printTextRaw(["value" => $lancement]);
            $row[] = printTextRaw(["value" => $line->marque]);
            $row[] = printTextRaw(["value" => $line->preco]);
            $row[] = printTextRaw(["value" => $date_preco]);
            $row[] = printTextRaw(["value" => $line->preco_activee]);
            $row[] = printTextRaw(["value" => $date_lancement]);
            $row[] = printTextRaw(["value" => $date_reception]);
            $row[] = printTextRaw(["value" => $line->statut]);
            $data[] = $row;
        }

        $output = [
            "draw" => $request->getPost("draw"),
            "recordsTotal" => $sales_model->countAll(),
            "recordsFiltered" => $sales_model->countFiltered($where),
            "data" => $data,
            "sistemator_token" => csrf_hash()
        ];

        echo json_encode($output);
    }


}
