<?php

namespace App\Controllers;

use App\Models\LancementsNowModel;
use Config\Database;

class LancementsNowController extends BaseController
{

    private $page_controller = "lancementsnow";
    private $page_route = "lancementsnow";


    public function index()
    {
        $model = new LancementsNowModel();

        // Récupérer les filtres de recherche
        $searchLancement = $this->request->getGet('search_lancement');
        $searchMarque = $this->request->getGet('search_marque');

        // Récupérer les données de la table `lancements` avec filtres
        $builder = $model->builder();
        if (!empty($searchLancement)) {
            $builder->like('lancement', $searchLancement);
        }
        if (!empty($searchMarque)) {
            $builder->like('marque', $searchMarque);
        }
        $lancements = $builder->get()->getResultArray();

        // Connexion à la base locale
        $db = Database::connect();

        // Requête pour récupérer les produits Prestashop
        $productQuery = "
        SELECT 
            id_product as product_id, 
            CONCAT(nom, ' ', declinaison) AS product_title, 
            product_reference, 
              attribute_reference,
            qte AS stock_quantity, 
            actif
        FROM prestashop_products
    ";

        $prestashopProducts = $db->query($productQuery)->getResultArray();

        // Indexer les produits par leur ID pour inclure toutes les lignes
        $productsIndexed = [];
        foreach ($prestashopProducts as $product) {
            if (!isset($productsIndexed[$product['product_id']])) {
                $productsIndexed[$product['product_id']] = [];
            }
            $productsIndexed[$product['product_id']][] = $product; // Ajouter chaque ligne
        }

        // Parcourir les lancements et ajouter les informations des produits
        foreach ($lancements as &$lancement) {
            if (!empty($lancement['id_produit'])) {
                // Extraire les IDs de type #12345
                preg_match_all('/#(\d+)/', $lancement['id_produit'], $matches);
                $productIds = $matches[1]; // Liste des IDs extraits

                $lancement['id_produit_details'] = []; // Stocker les détails des produits

                foreach ($productIds as $productId) {
                    if (isset($productsIndexed[$productId])) {
                        foreach ($productsIndexed[$productId] as $productDetails) {
                            $lancement['id_produit_details'][] = $productDetails; // Ajouter chaque détail
                        }
                    }
                }
            }
        }

        $output = [
            "page_controller" => $this->page_controller,
            "page_route" => $this->page_route,
            "page_button" => "",
            "page_title" => "Lancements",
            "lancements" => $lancements,
            "search_lancement" => $searchLancement,
            "search_marque" => $searchMarque,
        ];

        // Passer les données à la vue
        return view('lancementsnow/index', $output);
    }

}
