<?php

namespace App\Controllers;

use App\Models\GeneralModel;
use App\Controllers\BaseController;
use Config\Services;

class SysPreview extends BaseController
{
	public function SysUser($row_id=null) 
	{
		$row_id = dekripsi($row_id);

		$sysuserModel = new \App\Models\SysUserModel();
		$data = new \App\Entities\SysUserEntity();
		$data = $sysuserModel->getSelect("sysuser.row_id = '".$row_id."'");

		$output = [
			"data" => $data,
		];
		echo json_encode(["view" => view("sysuser/preview", $output)]);
	}

	public function SysIcon($row_id=null) 
	{
		$row_id = dekripsi($row_id);

		$sysiconModel = new \App\Models\SysIconModel();
		$data = new \App\Entities\SysIconEntity();
		$data = $sysiconModel->getSelect("sysicon.row_id = '".$row_id."'");

		$output = [
			"data" => $data,
		];
		echo json_encode(["view" => view("sysicon/preview", $output)]);
	}
	
	public function SysMenu($row_id=null) 
	{
		$row_id = dekripsi($row_id);

		$sysmenuModel = new \App\Models\SysMenuModel();
		$data = $sysmenuModel->getSelect("sysmenu.row_id = '".$row_id."'");

		$list_model = new \App\Models\SysMenuListModel();
		$list = $list_model->getTable($row_id);
		$lines = [];
		$columns = [
            ["text" => str("sysmenulist_menu_name"), "class" => "width-10"],
            ["text" => str("sysmenulist_route"), "class" => "width-10"],
            ["text" => str("sysmenulist_seq"), "class" => "width-10"],
		];
		foreach($list as $line) {
			$line_id = enkripsi($line->line_id);
			$row = [];
            $row[] = ["value" => printText(["value" => $line->menu_name])];
            $row[] = ["value" => printText(["value" => $line->route])];
            $row[] = ["value" => printNumber(["value" => $line->seq])];
			$lines[] = $row;
		}

		$output = [
			"data" => $data,
			"table_list" => table($columns, $lines),
		];
		echo json_encode(["view" => view("sysmenu/preview", $output)]);
	}

	public function SysUserAccess($row_id=null) 
	{
		$row_id = dekripsi($row_id);

		$sysuseraccessModel = new \App\Models\SysUserAccessModel();
		$data = $sysuseraccessModel->getSelect("sysuseraccess.row_id = '".$row_id."'");

		$access_model = new \App\Models\SysUserAccessAccessModel();
		$list = $access_model->getList("sysuseraccessaccess.row_id = '".$row_id."'");
		$lines = [];
		$columns = [
            ["text" => str("sysuseraccessaccess_menu_id"), "class" => "width-10"],
            ["text" => str("sysuseraccessaccess_access_control"), "class" => "width-10"],
		];
		foreach($list as $rows) {
			$line_id = enkripsi($rows["line_id"]);
			$line = new \App\Entities\SysUserAccessAccessEntity();
			$line->fill($rows);

			$row = [];
			$row[] = ["value" => printText(["value" => $line->menu_id_txt])];
			$row[] = ["value" => printText(["value" => $line->access_control])];
			$lines[] = $row;
		}

		$output = [
			"data" => $data,
			"table_access" => table($columns, $lines),
		];
		echo json_encode(["view" => view("sysuseraccess/preview", $output)]);
	}

	public function Customer($row_id=null) 
	{
		$row_id = dekripsi($row_id);

		$customerModel = new \App\Models\CustomerModel();
		$data = new \App\Entities\CustomerEntity();
		$data = $customerModel->getSelect("customer.row_id = '".$row_id."'");

		$output = [
			"data" => $data,
		];
		echo json_encode(["view" => view("customer/preview", $output)]);
	}

	public function Product($row_id=null) 
	{
		$row_id = dekripsi($row_id);

		$productModel = new \App\Models\ProductModel();
		$data = new \App\Entities\ProductEntity();
		$data = $productModel->getSelect("product.row_id = '".$row_id."'");

		$output = [
			"data" => $data,
		];
		echo json_encode(["view" => view("product/preview", $output)]);
	}

	public function Sales($row_id=null) 
	{
		$row_id = dekripsi($row_id);

		$salesModel = new \App\Models\SalesModel();
		$data = new \App\Entities\SalesEntity();
		$data = $salesModel->getSelect("sales.row_id = '".$row_id."'");

		$output = [
			"data" => $data,
		];
		echo json_encode(["view" => view("sales/preview", $output)]);
	}
}
