<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use Config\Services;

class SysSelectPopup extends BaseController
{    
	public function icon()
	{
		$request = Services::request();
		$datatable = new \App\Models\SysIconModel($request);
		$where = $request->getPost("where");
		$field_id = $request->getPost("field_id");

		$list = $datatable->getDatatables($where);
		$data = [];
		$no = $request->getPost("start");

		foreach ($list as $lines) {
			$row_id = $lines["row_id"];
			$line = new \App\Entities\SysIconEntity();
			$line->fill($lines);
	
			$button = button_selectpopup(["field_id" => $field_id, "value" => $row_id, "text" => $line->icon_code]);

			$row = [];
			$row[] = $button;
			$row[] = printIcon(["value" => $line->icon_code]);
			$row[] = printText(["value" => $line->icon_code]);
			$data[] = $row;
		}

		$output = [
			"draw" => $request->getPost("draw"),
			"recordsTotal" => $datatable->countAll(),
			"recordsFiltered" => $datatable->countFiltered($where),
			"data" => $data,
			"sistemator_token" => csrf_hash(),
		];

		echo json_encode($output);
	}		
    
	public function menu_id()
	{
		$request = Services::request();
		$datatable = new \App\Models\SysMenuListModel($request);
		$where = $request->getPost("where");
		$field_id = $request->getPost("field_id");

		$list = $datatable->getDatatables($where);
		$data = [];
		$no = $request->getPost("start");

		foreach ($list as $lines) {
			$line_id = $lines["line_id"];
			$line = new \App\Entities\SysMenuListEntity();
			$line->fill($lines);
	
			$button = button_selectpopup(["field_id" => $field_id, "value" => $line_id, "text" => $line->menu_name]);

			$row = [];
			$row[] = $button;
			$row[] = printText(["value" => $line->menu_name]);
			$data[] = $row;
		}

		$output = [
			"draw" => $request->getPost("draw"),
			"recordsTotal" => $datatable->countAll(),
			"recordsFiltered" => $datatable->countFiltered($where),
			"data" => $data,
			"sistemator_token" => csrf_hash(),
		];

		echo json_encode($output);
	}	
    
	public function customer_id()
	{
		$request = Services::request();
		$datatable = new \App\Models\CustomerModel($request);
		$where = $request->getPost("where");
		$field_id = $request->getPost("field_id");

		$list = $datatable->getDatatables($where);
		$data = [];
		$no = $request->getPost("start");

		foreach ($list as $lines) {
			$row_id = $lines["row_id"];
			$line = new \App\Entities\CustomerEntity();
			$line->fill($lines);
	
			$button = button_selectpopup(["field_id" => $field_id, "value" => $row_id, "text" => $line->name]);

			$row = [];
			$row[] = $button;
			$row[] = printText(["value" => $line->name]);
			$data[] = $row;
		}

		$output = [
			"draw" => $request->getPost("draw"),
			"recordsTotal" => $datatable->countAll(),
			"recordsFiltered" => $datatable->countFiltered($where),
			"data" => $data,
			"sistemator_token" => csrf_hash(),
		];

		echo json_encode($output);
	}
}
