<?php

function getMenu($user_access_id, $page_route) {    
    $menu = "";
    $sysmenu_model = new \App\Models\SysMenuModel();       
    
    if($user_access_id == 1) {
        $menu_list = $sysmenu_model->getMenuForAdmin();
    } else {
        $menu_list = $sysmenu_model->getMenuByUserAccessId($user_access_id);
    }

    if(!empty($menu_list)) {
        $current_folder = "";
        $controller_folder = "";
        $i = 0;

        foreach($menu_list as $line) {
            if($line->route == $page_route) {
                $controller_folder = $line->folder_name;
            }                  
        }

        foreach($menu_list as $row) {
            $menu_name = $row->menu_name;
            $folder_name = $row->folder_name;
            $menu_access = $row->access_control;
            $route = $row->route;
            $menu_seq = $row->menu_seq;
            $folder_seq = $row->folder_seq;
            $folder_icon = $row->icon_code;
            $url = admin_url($route);
            $active_menu = ($route == $page_route) ? ' class="mm-active"' : '';
            $active_folder = ($row->folder_name == $controller_folder) ? ' class="mm-active"' : '';

            if($i == 0) {
                $i = 1;
                $current_folder = $folder_name;

                $menu .= '
                    <li'.$active_folder.'> 
                        <a class="has-arrow" href="javascript:void(0)">
                            <i class="menu-icon fa '.$folder_icon.'"></i>
                            <span>'.$folder_name.'</span>
                        </a>
                        <ul class="sub-menu" aria-expanded="false">
                            <li'.$active_menu.'><a href="'.$url.'">'.$menu_name.'</a></li>

                ';
            } else {
                if($current_folder <> $folder_name) {
                    $current_folder = $folder_name;
                    $menu .= '
                        </ul>
                    </li>
                    <li'.$active_folder.'> 
                        <a class="has-arrow" href="javascript:void(0)">
                        <i class="menu-icon fa '.$folder_icon.'"></i>
                            <span>'.$folder_name.'</span>
                        </a>
                        <ul class="sub-menu" aria-expanded="false">
                            <li'.$active_menu.'><a href="'.$url.'">'.$menu_name.'</a></li>

                    ';

                } else {
                    $menu .= '<li'.$active_menu.'><a href="'.$url.'">'.$menu_name.'</a></li>';
                }
            }
        }
        $menu .= '
                        </ul>
                    </li>';
    }

    return $menu;
    
}
?>