<?php

namespace App\Models;

use CodeIgniter\Model;

class ArticlesCommandesClientModel extends Model
{
    protected $table = 'articlesCommandesClient';
    protected $primaryKey = 'id'; // Remplacez par la clé primaire réelle
    protected $allowedFields = ['Réf. Commande', 'N° Client', 'Réf Article', 'Désignation', 'ML', 'MG', 'Qté Commandées'];

    public function getArticlesByCommandes(array $commandes)
    {
        if (empty($commandes)) {
            return []; // Retourner un tableau vide si aucune commande n'est fournie
        }

        $placeholders = implode(',', array_fill(0, count($commandes), '?'));

        $sql = "
        SELECT 
            `N° Client` AS Client_Id,
            `Réf Article` AS Ref_Article,
            `Désignation`,
            `ML`,
            `MG`,
            SUM(`Qté Commandées`) AS Quantité
        FROM `articlesCommandesClient`
        WHERE `Réf. Commande` IN ($placeholders)
        GROUP BY `N° Client`, `Réf Article`, `Désignation`, `ML`, `MG`
        ORDER BY `Réf Article` ASC
    ";

        $query = $this->db->query($sql, $commandes);

        return $query->getResultArray(); // Retourner les résultats sous forme de tableau associatif
    }

}
