<?php

namespace App\Models;

use CodeIgniter\Model;

class ArticlesExpeditionsModel extends Model
{
    protected $table = 'articlesExpeditions';
    protected $primaryKey = 'id'; // Remplacez par la clé primaire réelle
    protected $allowedFields = ['Réf. Commande', 'Statut expédition', 'Date expédition'];

    public function getExpeditions($startDate, $endDate)
    {
        $sql = "
        SELECT DISTINCT `Réf. Commande`
        FROM `articlesExpeditions`
        WHERE `Statut expédition` = 'Expédié'
          AND `Date expédition` >= :start_date:
          AND `Date expédition` <= :end_date:
    ";

        $query = $this->db->query($sql, [
            'start_date' => $startDate,
            'end_date' => $endDate,
        ]);

        return $query->getResultArray();
    }
}
