<?= $this->extend('web_layout/admin/dashboard_layout') ?>

<?= $this->section('content') ?>

<?= inputHidden(["sistemator_token" => csrf_hash()]); ?>

<div class="row">
    <div class="col-xl-3 col-md-6">
        <div class="card card-h-100">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-12">
                        <span class="text-muted mb-3 lh-1 d-block text-truncate">My Wallet</span>
                        <h4 class="mb-3">$<span class="counter-value" data-target="<?= $total[0]->amount ?>">0</span></h4>
                    </div>
                </div>
                <div class="text-nowrap">
                    <span class="badge bg-soft-success text-success">+<?= $total[0]->amount ?></span>
                    <span class="ms-1 text-muted font-size-13">point</span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card card-h-100">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-12">
                        <span class="text-muted mb-3 lh-1 d-block text-truncate">My Wallet</span>
                        <h4 class="mb-3">$<span class="counter-value" data-target="<?= $total[0]->amount ?>">0</span></h4>
                    </div>
                </div>
                <div class="text-nowrap">
                    <span class="badge bg-soft-danger text-danger">+<?= $total[0]->amount ?></span>
                    <span class="ms-1 text-muted font-size-13">point</span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card card-h-100">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-12">
                        <span class="text-muted mb-3 lh-1 d-block text-truncate">My Wallet</span>
                        <h4 class="mb-3">$<span class="counter-value" data-target="<?= $total[0]->amount ?>">0</span></h4>
                    </div>
                </div>
                <div class="text-nowrap">
                    <span class="badge bg-soft-success text-success">+<?= $total[0]->amount ?></span>
                    <span class="ms-1 text-muted font-size-13">point</span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card card-h-100">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-12">
                        <span class="text-muted mb-3 lh-1 d-block text-truncate">My Wallet</span>
                        <h4 class="mb-3">$<span class="counter-value" data-target="<?= $total[0]->amount ?>">0</span></h4>
                    </div>
                </div>
                <div class="text-nowrap">
                    <span class="badge bg-soft-danger text-danger">+<?= $total[0]->amount ?></span>
                    <span class="ms-1 text-muted font-size-13">point</span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">                     
    <div class="col-sm-4">
        <div class="card card-h-100">
            <div class="card-body">
                <div id="halfpie_chart"></div> 
            </div>
        </div>
    </div>                       
    <div class="col-sm-4">
        <div class="card card-h-100">
            <div class="card-body">
                <div id="pie_chart"></div> 
            </div>
        </div>
    </div> 
    <div class="col-xl-4">
        <div class="card">
            <div class="card-header align-items-center d-flex">
                <h4 class="card-title mb-0 flex-grow-1">Last transaction</h4>
            </div>

            <div class="card-body px-0">
                <div class="px-3" data-simplebar style="max-height: 352px;">
                    <ul class="list-unstyled activity-wid mb-0">
                        <?php
                            if(!empty($sales_list)) {
                                $i = 1;
                                foreach($sales_list as $row) {
                                    if($i <= 5) {
                                        $list = '
                                        <li class="activity-list activity-border">
                                            <div class="activity-icon avatar-md">
                                                <span class="avatar-title bg-soft-primary text-primary rounded-circle">
                                                    <i class="fa fa-money font-size-24"></i>
                                                </span>
                                            </div>
                                            <div class="timeline-list-item">
                                                <div>'.printDate(["value" => $row->trans_date]).'</div>
                                                <div class="text-truncate">'.printText(["value" => $row->description]).'</div>
                                                <div class="font-size-13">'.printMoney(["value" => $row->total_amount]).'</div>                                            
                                            </div>
                                        </li>
                                        ';
                                        echo $list;
                                    }
                                    $i++;
                                }
                            }
                        ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>       

    <div class="col-sm-12">
        <div class="card card-h-100">
            <div class="card-body">
                <div id="column_chart"></div> 
            </div>
        </div>
    </div>       
    <div class="col-sm-6">
        <div class="card card-h-100">
            <div class="card-body">
                <div id="line_chart"></div> 
            </div>
        </div>
    </div>             
    <div class="col-sm-6">
        <div class="card card-h-100">
            <div class="card-body">
                <div id="bar_chart"></div> 
            </div>
        </div>
    </div> 
</div>

<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    function page_load() 
    {
        get_monthly_product();
        get_achievement();
        get_portion();      
    }

    function get_monthly_product() 
    {
        var form_data = {
            sistemator_token: $("#sistemator_token").val(),
        };

        response = get_datachart("<?= admin_url($page_route."/get-monthly-product") ?>", form_data);

        var series = [];
        var categories = [];

        categories.push("Jan");
        categories.push("Feb");
        categories.push("Mar");
        categories.push("Apr");
        categories.push("May");
        categories.push("Jun");
        categories.push("Jul");
        categories.push("Aug");
        categories.push("Sep");
        categories.push("Oct");
        categories.push("Nov");
        categories.push("Des");

        for (var i in response) {
            var val = [];
            val.push(Number(response[i].jan));
            val.push(Number(response[i].feb));
            val.push(Number(response[i].mar));
            val.push(Number(response[i].apr));
            val.push(Number(response[i].may));
            val.push(Number(response[i].jun));
            val.push(Number(response[i].jul));
            val.push(Number(response[i].aug));
            val.push(Number(response[i].sep));
            val.push(Number(response[i].oct));
            val.push(Number(response[i].nov));
            val.push(Number(response[i].des));
            series.push({ name: response[i].product_id_txt, data: val, visible: true });
        }

        draw_line(categories, series, "line_chart", "Sales Monthly", "");
        draw_bar(categories, series, "bar_chart", "Sales Monthly", "");
        draw_column(categories, series, "column_chart", "Sales Monthly", "");
    }

    function get_achievement() 
    {
        var form_data = {
            sistemator_token: $("#sistemator_token").val(),
        };

        var target = 10000000;
        var amount;
        var achievement;
        response = get_datachart("<?= admin_url($page_route."/get-achievement") ?>", form_data);

        for (var i in response) {
            amount = Number(response[i].amount);
        }

        achievement = (amount / target) * 100;
        achievement = Number(decimal_2(achievement));

        draw_speedometer(achievement, 100, "Percent", "halfpie_chart", "Achievement");
    }

    function get_portion() 
    {
        var form_data = {
            sistemator_token: $("#sistemator_token").val(),
        };

        response = get_datachart("<?= admin_url($page_route."/get-portion") ?>", form_data);

        var series = [];

        for (var i in response) {
            series.push([response[i].product_id_txt, Number(response[i].amount)]);
        }

        draw_pie(series, "pie_chart", "Portion", "Portion");
    }
</script>

<?= $this->endSection() ?>