<?= $this->extend('web_layout/admin/auth_layout') ?>

<?= $this->section('content') ?>

<div class="row justify-content-center">
    <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 col-xl-4">
        <div class="auth-content my-auto">
            <div class="text-center">
                <img src="<?= asset_uploaded()."/".session()->get("company_logo") ?>" style="height:35px" />
                <p class="text-muted mt-2"><?= session()->get("application_name") ?></p>
            </div>
            <div class="custom-form mt-4 pt-2">                
                <?php                            
                    echo form_open_multipart(auth_url("save-login"), ["id" => "form_input"]);
                    echo inputHidden(["sistemator_token" => csrf_hash()]);
                ?>
                <div class="mb-3">
                    <?= inputText(["id" => "user_id", "label" => "Utilisateur", "placeholder" => ""]); ?>
                </div>
                <div class="mb-3">
                    <div class="d-flex align-items-start">
                        <div class="flex-grow-1">
                            <label class="form-label">Mot de passe</label>
                        </div>
                    </div>                    
                    <div class="input-group auth-pass-inputgroup">
                        <input id="pswrd" name="pswrd" type="password" class="form-control" placeholder=" " aria-label="Password" aria-describedby="password-addon">
                        <button class="btn btn-light ms-0" type="button" id="password-addon"><i class="fa fa-eye"></i></button>
                    </div>
                </div>
                <!-- <div class="row mb-4">
                    <div class="col">
                        <a href="recover-password.html">Forgot password?</a>
                    </div>                    
                </div> -->
                <div class="mb-3 text-center">
                    <a class="btn btn-success btn-auth waves-effect waves-light" href="javascript:void(0)" onclick="auth('form_input', 'btn_save')">Log In</a>
                </div>
                <?= form_close() ?>   
                <br><br><br>

            </div>
        </div>
    </div>
</div>


<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    function page_load() {
        $("#password-addon").on('click', function () {
            if ($(this).siblings('input').length > 0) {
                $(this).siblings('input').attr('type') == "password" ? $(this).siblings('input').attr('type', 'input') : $(this).siblings('input').attr('type', 'password');
            }
        })
    }

    function validation() {
        var ret = true;
        if($("#user_id").val() == "") {error("User Id must be filled"); ret = false}
        if($("#pswrd").val() == "") {error("Password must be filled"); ret = false}
        return ret;
    }

    function after_exec(ret) {
        var url = "<?= admin_url("") ?>";
        var data = JSON.parse(ret); 
        var msg = data["msg"];
        var status = data["status"];
        var token = data["sistemator_token"];
        $("#sistemator_token").val(token);

        if(status == 1) {
            success(msg, url); 
        } else {
            error(msg);              
        }
    }
    
</script>

<?= $this->endSection() ?>