<?= $this->extend('web_layout/admin/form_layout') ?>

<?= $this->section('content') ?>

<?php
    $list[] = ["text" => $page_title, "url" => admin_url($page_route)];
    $list[] = ["text" => str("form"), "url" => admin_url($page_route."/form/".$row_id)];
    $list[] = ["text" => str("sysmenulist")];
    echo breadcrumb($list);
?>

<div class="row">
    <?php                            
        echo form_open_multipart(admin_url($page_route."/save-list"), ["id" => "form_input"]);
        echo inputHidden(["sistemator_token" => csrf_hash()]);
        echo inputHidden(["row_id" => $row_id]);
        echo inputHidden(["line_id" => $line_id]);
    ?>
    <div class="col-12">
        <div class="row">
            <div class="col-md-4 mb-5">
                <?= inputText(["src" => $data, "id" => "menu_name", "label" => str("sysmenulist_menu_name"), "mandatory" => 1]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= inputText(["src" => $data, "id" => "route", "label" => str("sysmenulist_route"), "mandatory" => 1]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= inputNumber(["src" => $data, "id" => "seq", "label" => str("sysmenulist_seq"), "mandatory" => 1]); ?>
            </div>
        </div>
    </div>   
    <?= form_close() ?>     
</div>   

<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    function page_load() {     
        $("#route").keyup(function(e) {
            var str = $(this).val();
            str = str_route_url(str);
            $("#route").val(str.toLowerCase());
        });
    }

    function validation() {
        var ret = true;
        if($("#menu_name").val() == "") {error("Menu must be filled"); ret = false}
        if($("#route").val() == "") {error("Route must be filled"); ret = false}
        if($("#seq").val() == "") {error("Sequence must be filled"); ret = false}
        return ret;
    }

    function deleteList() {
        var csrf = $("#sistemator_token").val();
        var url = "<?= admin_url($page_route) ?>/delete-list/";
        var id = $("#line_id").val();
        exec_delete(csrf, url, id);          
    }

    function after_exec(ret) {
        var row_id = $("#row_id").val();
        var url = "<?= admin_url($page_route."/form/") ?>" + row_id;
        var data = JSON.parse(ret); 
        var msg = data["msg"];
        var status = data["status"];
        var token = data["sistemator_token"];
        $("#sistemator_token").val(token);

        if(status == 1) {
            success(msg, url); 
        } else {
            error(msg);              
        }
    }
    
</script>

<?= $this->endSection() ?>