<?= $this->extend('web_layout/admin/form_layout') ?>

<?= $this->section('content') ?>

<?php
    $list[] = ["text" => $page_title, "url" => admin_url($page_route)];
    $list[] = ["text" => str("form")];
    echo breadcrumb($list);
?>

<div class="row">
    <?php                            
        echo form_open_multipart(admin_url($page_route."/save"), ["id" => "form_input"]);
        echo inputHidden(["sistemator_token" => csrf_hash()]);
        echo inputHidden(["row_id" => $row_id]);
    ?>
    <div class="col-12">
        <div class="row">
            <div class="col-md-4 mb-5">
                <?= inputText(["src" => $data, "id" => "name", "label" => str("sysuseraccess_name"), "mandatory" => 1]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= inputText(["src" => $data, "id" => "notes", "label" => str("sysuseraccess_notes")]); ?>
            </div>
        </div>
    </div>  
    <div class="col-12">
        <div class="row">
            <div class="col-md-12 mt-3 border-left">   
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#table_access" role="tab">Access</a></li>
                </ul>
                <div class="tab-content pt-3">
                    <div class="tab-pane active" id="table_access" role="tabpanel">
                        <?= $table_access ?>  
                    </div>
                </div>           
            </div>
        </div>
    </div>  
    <?= form_close() ?>     
</div>   

<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    function page_load() {
        
    }

    function validation() {
        var ret = true;
        if($("#name").val() == "") {error("User access must be filled"); ret = false}
        return ret;
    }

    function deleteSysUserAccess() {
        var csrf = $("#sistemator_token").val();
        var url = "<?= admin_url($page_route) ?>/delete/";
        var id = $("#row_id").val();
        exec_delete(csrf, url, id);          
    }

    function after_exec(ret) {
        var url = "<?= admin_url($page_route) ?>";
        var data = JSON.parse(ret); 
        var msg = data["msg"];
        var status = data["status"];
        var token = data["sistemator_token"];
        $("#sistemator_token").val(token);

        if(status == 1) {
            success(msg, url); 
        } else {
            error(msg);              
        }
    }
    
</script>

<?= $this->endSection() ?>