<?= $this->extend('web_layout/admin/datatable_layout') ?>

<?= $this->section('content') ?>

<?= inputHidden(["sistemator_token" => csrf_hash()]); ?>

<?php
    $column[] = ["text" => "", "class" => "width-10"];
    $column[] = ["text" => str("sysuseraccess_name"), "class" => "width-30"];
    $column[] = ["text" => str("sysuseraccess_notes"), "class" => "width-60"];
    echo datatable("table", $column);
?>

<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    var where = "";
    var datatable;

    function page_load() 
    {
        bind_table();        
    }

    function bind_table() 
    {
        var tableId = '#table';
        var url = '<?= admin_url($page_route.'/list') ?>';
        datatable = $(tableId).DataTable({ 
            "processing": true, 
            "serverSide": true, 
            "ordering": false,
            "dom": 't<"bottom datatable-ext"fpi>',
            "ajax": {
                "url": url,
                "type": "POST",
                "data": function(data) {
                    data.sistemator_token = $("#sistemator_token").val();
                    data.where = where;
                },
                "dataSrc": function(response) {
                    $('#sistemator_token').val(response.sistemator_token);                
                    return response.data;
                }
            }
        });
    }
</script>

<?= $this->endSection() ?>