<?= $this->extend('web_layout/admin/form_layout') ?>

<?= $this->section('content') ?>

<div class="row">
    <?php                            
        echo form_open_multipart(admin_url($page_route."/save"), ["id" => "form_input"]);
        echo inputHidden(["sistemator_token" => csrf_hash()]);
        echo inputHidden(["row_id" => $row_id]);
    ?>
    <div class="col-12">
        <div class="row">
            <div class="col-md-4 mb-5">
                <?= inputText(["src" => $data, "id" => "company_name", "label" => str("syswebinfo_company_name")]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= inputText(["src" => $data, "id" => "application_name", "label" => str("syswebinfo_application_name")]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= dropdownList(["src" => $data, "id" => "format_date", "label" => str("syswebinfo_format_date"), "list" => $format_date_list]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= inputText(["src" => $data, "id" => "currency", "label" => str("syswebinfo_currency")]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= uploadFile(["src" => $data, "id" => "web_icon", "label" => str("syswebinfo_web_icon")]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= uploadFile(["src" => $data, "id" => "company_logo", "label" => str("syswebinfo_company_logo")]); ?>
            </div>
        </div>
    </div>   
    <?= form_close() ?>     
</div>   

<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    function page_load() {
        
    }

    function validation() {
        var ret = true;
        return ret;
    }

    function deleteSysWebInfo() {
        var csrf = $("#sistemator_token").val();
        var url = "<?= admin_url($page_route) ?>/delete/";
        var id = $("#row_id").val();
        exec_delete(csrf, url, id);          
    }

    function after_exec(ret) {
        var url = "<?= admin_url($page_route) ?>";
        var data = JSON.parse(ret); 
        var msg = data["msg"];
        var status = data["status"];
        var token = data["sistemator_token"];
        $("#sistemator_token").val(token);

        if(status == 1) {
            success(msg, url); 
        } else {
            error(msg);              
        }
    }
    
</script>

<?= $this->endSection() ?>