<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?= session()->get("application_name")." | ".session()->get("company_name") ?></title>
        <link rel="shortcut icon" href="<?= asset_uploaded()."/".session()->get("web_icon") ?>">
        <link rel="stylesheet" href="<?= base_url() ?>/assets/css/pace.css"type="text/css" />
        <link href="<?= base_url() ?>/assets/fontawesome/css/all.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/libs/summernote/summernote.css" rel="stylesheet">
        <link href="<?= base_url() ?>/assets/libs/flatpickr/flatpickr.min.css" rel="stylesheet" >
        <link href="<?= base_url() ?>/assets/css/bootstrap.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/css/style.css" id="app-style" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/css/custom.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/css/loading.css" rel="stylesheet" type="text/css" />
    </head>

    <body>
    
        <div id="loading_bar" class="loading loading-hide">Loading&#8230;</div>

        <div id="layout-wrapper">

            <?= $this->include('web_layout/admin/header') ?>

            <?= $this->include('web_layout/admin/menu') ?>
            
            <div class="main-content" id="miniaresult">
                <div class="page-content">
                    <div class="container-fluid">
                        <?= $this->renderSection('content') ?>	
                    </div>  	
                </div>
			</div>

            <?= $this->include('web_layout/admin/footer') ?>

        </div>

        <script src="<?= base_url() ?>/assets/libs/jquery/jquery.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/datatables.net/js/datatables.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/metismenu/metisMenu.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/simplebar/simplebar.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/node-waves/waves.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/feather-icons/feather.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/pace-js/pace.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/sweetalert2/sweetalert2.min.js"></script>
        <script src="<?= base_url() ?>/assets/js/pages/sweetalert.init.js"></script>
        <script src="<?= base_url() ?>/assets/libs/flatpickr/flatpickr.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/summernote/summernote-bootstrap.js"></script>
        <script src="<?= base_url() ?>/assets/libs/summernote/summernote.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/summernote/summernote-custom.js"></script>  
        <script src="<?= base_url() ?>/assets/js/form.js"></script>
        <script src="<?= base_url() ?>/assets/js/app.js"></script>

        <script type="text/javascript">
            $(document).ready(function() {
				'use strict';
                page_load();                

                $(".input-money").keyup(function() {                                
                    format_currency($(this));
                });

                $(".input-money").blur(function() {                                
                    format_currency($(this));
                });
            });
        </script>

        <?= $this->renderSection('javascript') ?>	

    </body>

</html>