<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?= session()->get("application_name")." | ".session()->get("company_name") ?></title>
        <link rel="shortcut icon" href="<?= asset_uploaded()."/".session()->get("web_icon") ?>">
        <link rel="stylesheet" href="<?= base_url() ?>/assets/css/pace.css"type="text/css" />
        <link href="<?= base_url() ?>/assets/css/bootstrap.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/fontawesome/css/all.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/css/style.css" id="app-style" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/css/custom.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/css/loading.css" rel="stylesheet" type="text/css" />
    </head>

    <body data-layout="horizontal">    
        <div id="loading_bar" class="loading loading-hide">Loading&#8230;</div>
        
        <div id="layout-wrapper">

            <header id="page-topbar">
                <div class="navbar-header">
                    <div class="d-flex">
                        <div class="navbar-brand-box">
                            <a href="<?= admin_url("") ?>" class="logo logo-dark">
                                <span class="logo-sm">
                                    <img src="<?= asset_uploaded()."/".session()->get("web_icon") ?>" alt="" height="24">
                                </span>
                                <span class="logo-lg">
                                    <img src="<?= asset_uploaded()."/".session()->get("web_icon") ?>" alt="" height="24">
                                </span>
                            </a>

                            <a href="<?= admin_url("") ?>" class="logo logo-light">
                                <span class="logo-sm">
                                    <img src="<?= asset_uploaded()."/".session()->get("web_icon") ?>" alt="" height="24">
                                </span>
                                <span class="logo-lg">
                                    <img src="<?= asset_uploaded()."/".session()->get("web_icon") ?>" alt="" height="24">
                                </span>
                            </a>
                        </div>

                        <button type="button" class="btn btn-sm px-3 font-size-16 d-lg-none header-item waves-effect waves-light" data-bs-toggle="collapse" data-bs-target="#topnav-menu-content">
                            <i class="fa fa-fw fa-bars"></i>
                        </button>
                    </div>

                    <div class="d-flex">
                        <div class="dropdown d-inline-block">
                            <button type="button" class="btn header-item bg-soft-light border-start border-end" id="page-header-user-dropdown"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <span class="d-none d-xl-inline-block ms-1 fw-medium">Shawn L.</span>
                                <i class="mdi mdi-chevron-down d-none d-xl-inline-block"></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end">
                                <a class="dropdown-item" href="#"><i class="mdi mdi-face-profile font-size-16 align-middle me-1"></i> Profile</a>
                                <a class="dropdown-item" href="#"><i class="mdi mdi-credit-card-outline font-size-16 align-middle me-1"></i> Billing</a>
                                <a class="dropdown-item" href="#"><i class="mdi mdi-account-settings font-size-16 align-middle me-1"></i> Settings</a>
                                <a class="dropdown-item" href="#"><i class="mdi mdi-lock font-size-16 align-middle me-1"></i> Lock screen</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="#"><i class="mdi mdi-logout font-size-16 align-middle me-1"></i> Logout</a>
                            </div>
                        </div>
            
                    </div>
                </div>
            </header>

            <div class="topnav">
                <div class="container-fluid">
                    <nav class="navbar navbar-light navbar-expand-lg topnav-menu">

                        <div class="collapse navbar-collapse" id="topnav-menu-content">
                            <ul class="navbar-nav">
                                <li class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle arrow-none" href="index.html" id="topnav-dashboard" role="button">Home</a>
                                </li>
                                <li class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle arrow-none" href="index.html" id="topnav-dashboard" role="button">Documentation</a>
                                </li>
                                <li class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle arrow-none" href="index.html" id="topnav-dashboard" role="button">FAQ</a>
                                </li>
                                <li class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle arrow-none" href="index.html" id="topnav-dashboard" role="button">Changelog</a>
                                </li>
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
            
            <div class="main-content" id="miniaresult">
                <div class="page-content">
                    <div class="container-fluid">
                        <?= $this->renderSection('content') ?>	
                    </div>
                </div>
			</div>

        </div>

        <script src="<?= base_url() ?>/assets/libs/jquery/jquery.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/metismenu/metisMenu.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/simplebar/simplebar.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/node-waves/waves.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/feather-icons/feather.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/pace-js/pace.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/sweetalert2/sweetalert2.min.js"></script>
        <script src="<?= base_url() ?>/assets/js/pages/sweetalert.init.js"></script>
        <script src="<?= base_url() ?>/assets/libs/datatables.net/js/datatables.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/highcharts/highcharts.js"></script>
        <script src="<?= base_url() ?>/assets/libs/highcharts/highcharts-more.js"></script>
        <script src="<?= base_url() ?>/assets/libs/highcharts/highcharts-solid-gauge.js"></script>
        <script src="<?= base_url() ?>/assets/libs/highcharts/highcharts-theme.js"></script>
        <script src="<?= base_url() ?>/assets/libs/highcharts/highcharts-main.js"></script>
        <script src="<?= base_url() ?>/assets/js/view.js"></script>
        <script src="<?= base_url() ?>/assets/js/datatable.js"></script>
        <script src="<?= base_url() ?>/assets/js/form.js"></script>
        <script src="<?= base_url() ?>/assets/js/app.js"></script>

    </body>

</html>